/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.internal.solr.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.search.documents.IDocument;
import org.eclipse.gyrex.search.facets.IFacet;
import org.eclipse.gyrex.search.internal.solr.documents.StoredDocument;
import org.eclipse.gyrex.search.internal.solr.query.QueryImpl;
import org.eclipse.gyrex.search.internal.solr.result.ResultFacet;
import org.eclipse.gyrex.search.internal.solr.result.ResultFacetValue;
import org.eclipse.gyrex.search.query.IQuery;
import org.eclipse.gyrex.search.result.IResult;
import org.eclipse.gyrex.search.result.IResultFacet;

public class ResultImpl
extends PlatformObject
implements IResult {
    private final QueryResponse response;
    private List<IDocument> documents;
    private Map<String, IResultFacet> facets;
    private final IRuntimeContext context;
    private final QueryImpl query;

    public ResultImpl(IRuntimeContext context, QueryImpl query, QueryResponse response) {
        this.context = context;
        this.query = query;
        this.response = response;
    }

    private ResultFacet createFacet(FacetField facetField) {
        Map<String, IFacet> facetsInUse = this.query.getFacetsInUse();
        if (facetsInUse == null) {
            return null;
        }
        IFacet facet = facetsInUse.get(facetField.getName());
        if (facet == null) {
            return null;
        }
        List values = facetField.getValues();
        if (values == null || values.isEmpty()) {
            return null;
        }
        ResultFacet f = new ResultFacet(facet);
        for (FacetField.Count count : values) {
            f.addValue(new ResultFacetValue(count.getCount(), count.getName()));
        }
        return f;
    }

    @Override
    public IRuntimeContext getContext() {
        return this.context;
    }

    @Override
    public List<IDocument> getDocuments() {
        if (this.documents != null) {
            return this.documents;
        }
        SolrDocumentList results = this.response.getResults();
        if (results.isEmpty()) {
            this.documents = Collections.emptyList();
            return this.documents;
        }
        ArrayList<StoredDocument> docs = new ArrayList<StoredDocument>(results.size());
        for (SolrDocument result : results) {
            docs.add(new StoredDocument(result));
        }
        this.documents = Collections.unmodifiableList(docs);
        return this.documents;
    }

    @Override
    public Map<String, IResultFacet> getFacets() {
        if (this.facets != null) {
            return this.facets;
        }
        List facetFields = this.response.getFacetFields();
        if (facetFields == null || facetFields.isEmpty()) {
            this.facets = Collections.emptyMap();
            return this.facets;
        }
        HashMap<String, ResultFacet> facets = new HashMap<String, ResultFacet>(facetFields.size());
        if (facetFields != null) {
            for (FacetField facetField : facetFields) {
                ResultFacet facet = this.createFacet(facetField);
                if (facet == null) continue;
                facets.put(facet.getFacet().getAttributeId(), facet);
            }
        }
        this.facets = Collections.unmodifiableMap(facets);
        return this.facets;
    }

    @Override
    public long getNumFound() {
        return this.response.getResults().getNumFound();
    }

    @Override
    public IQuery getQuery() {
        return this.query;
    }

    @Override
    public long getQueryTime() {
        return this.response.getQTime();
    }

    @Override
    public long getStartOffset() {
        return this.response.getResults().getStart();
    }
}

