/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.outline;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.internal.examples.basic.ui.FooContentProvider;
import org.eclipse.handly.internal.examples.basic.ui.FooLabelProvider;
import org.eclipse.handly.internal.examples.basic.ui.SourceElementUtil;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.IHandleDelta;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.xtext.ui.editor.IXtextEditorAware;
import org.eclipse.xtext.ui.editor.XtextEditor;

public final class FooOutlinePage
extends ContentOutlinePage
implements IXtextEditorAware,
IElementChangeListener {
    private XtextEditor editor;
    private LinkingHelper linkingHelper;
    @Inject
    private FooContentProvider contentProvider;
    @Inject
    private FooLabelProvider labelProvider;

    public void setEditor(XtextEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)this.contentProvider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.getTreeViewer().setInput(this.computeInput());
        this.linkingHelper = new LinkingHelper();
        FooModelCore.getFooModel().addElementChangeListener(this);
    }

    public void dispose() {
        FooModelCore.getFooModel().removeElementChangeListener(this);
        this.linkingHelper.dispose();
        this.editor.outlinePageClosed();
        super.dispose();
    }

    public void elementChanged(IElementChangeEvent event) {
        if (this.affects(event.getDelta(), (IHandle)this.getTreeViewer().getInput())) {
            final Control control = this.getTreeViewer().getControl();
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        FooOutlinePage.this.refresh();
                    }
                }
            });
        }
    }

    private boolean affects(IHandleDelta delta, IHandle element) {
        IHandleDelta[] children;
        if (delta.getElement().equals((Object)element)) {
            return true;
        }
        IHandleDelta[] iHandleDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IHandleDelta child = iHandleDeltaArray[n2];
            if (this.affects(child, element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Object computeInput() {
        IEditorInput editorInput = this.editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            return FooModelCore.create(file);
        }
        return null;
    }

    private void refresh() {
        Control control = this.getControl();
        control.setRedraw(false);
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                TreePath[] treePaths = FooOutlinePage.this.getTreeViewer().getExpandedTreePaths();
                FooOutlinePage.this.getTreeViewer().refresh();
                FooOutlinePage.this.getTreeViewer().setExpandedTreePaths(treePaths);
            }
        });
        control.setRedraw(true);
    }

    private class LinkingHelper
    extends OpenAndLinkWithEditorHelper {
        private ISelectionChangedListener editorListener;

        public LinkingHelper() {
            super((StructuredViewer)FooOutlinePage.this.getTreeViewer());
            this.editorListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!FooOutlinePage.this.getTreeViewer().getControl().isFocusControl()) {
                        LinkingHelper.this.linkToOutline(event.getSelection());
                    }
                }
            };
            this.setLinkWithEditor(true);
            ISelectionProvider selectionProvider = FooOutlinePage.this.editor.getSite().getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.editorListener);
            } else {
                selectionProvider.addSelectionChangedListener(this.editorListener);
            }
        }

        public void dispose() {
            ISelectionProvider selectionProvider = FooOutlinePage.this.editor.getSite().getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.editorListener);
            } else {
                selectionProvider.removeSelectionChangedListener(this.editorListener);
            }
            super.dispose();
        }

        public void setLinkWithEditor(boolean enabled) {
            super.setLinkWithEditor(enabled);
            if (enabled) {
                this.linkToOutline(FooOutlinePage.this.editor.getSite().getSelectionProvider().getSelection());
            }
        }

        protected void activate(ISelection selection) {
            this.linkToEditor(selection);
        }

        protected void open(ISelection selection, boolean activate) {
            this.linkToEditor(selection);
        }

        protected void linkToEditor(ISelection selection) {
            if (selection == null || selection.isEmpty()) {
                return;
            }
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (!(element instanceof ISourceElement)) {
                return;
            }
            SourceElementUtil.revealInTextEditor((ITextEditor)FooOutlinePage.this.editor, (ISourceElement)element);
        }

        protected void linkToOutline(ISelection selection) {
            IStructuredSelection currentSelection;
            if (selection == null || selection.isEmpty()) {
                return;
            }
            IStructuredSelection linkedSelection = null;
            if (selection instanceof ITextSelection) {
                linkedSelection = this.getLinkedSelection((ITextSelection)selection);
            }
            if (!(linkedSelection == null || (currentSelection = (IStructuredSelection)FooOutlinePage.this.getTreeViewer().getSelection()) != null && currentSelection.toList().containsAll(linkedSelection.toList()))) {
                FooOutlinePage.this.getTreeViewer().setSelection((ISelection)linkedSelection, true);
            }
        }

        private IStructuredSelection getLinkedSelection(ITextSelection selection) {
            Object input = FooOutlinePage.this.getTreeViewer().getInput();
            if (!(input instanceof ISourceElement)) {
                return null;
            }
            ISourceFile sourceFile = ((ISourceElement)input).getSourceFile();
            ISourceElement element = SourceElementUtil.getSourceElement(sourceFile, selection.getOffset());
            if (element == null) {
                return null;
            }
            return new StructuredSelection((Object)element);
        }
    }
}

