/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.handly.xtext.ui.editor.HandlyXtextDocument;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.SchedulingRuleFactory;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class HandlyDirtyStateEditorSupport
extends DirtyStateEditorSupport {
    public static final Object FAMILY_DIRTY_STATE_RECONCILER = new Object();
    protected static final ISchedulingRule RECONCILER_RULE = SchedulingRuleFactory.INSTANCE.newSequence();
    private volatile DirtyStateEditorSupport.IDirtyStateEditorSupportClient currentClient;
    private DirtyStateReconciler dirtyStateReconciler;

    public void initializeDirtyStateSupport(DirtyStateEditorSupport.IDirtyStateEditorSupportClient client) {
        super.initializeDirtyStateSupport(client);
        this.currentClient = client;
    }

    public void removeDirtyStateSupport(DirtyStateEditorSupport.IDirtyStateEditorSupportClient client) {
        super.removeDirtyStateSupport(client);
        this.currentClient = null;
    }

    public void descriptionsChanged(IResourceDescription.Event event) {
        if (!this.getDirtyResource().isInitialized()) {
            return;
        }
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            if (delta.getOld() != this.getDirtyResource().getDescription() && delta.getNew() != this.getDirtyResource().getDescription()) continue;
            return;
        }
        this.scheduleReconciler(event);
    }

    protected final DirtyStateEditorSupport.IDirtyStateEditorSupportClient getCurrentClient() {
        return this.currentClient;
    }

    protected DirtyStateReconciler createReconciler() {
        return new DirtyStateReconciler(RECONCILER_RULE);
    }

    protected final void scheduleReconciler(IResourceDescription.Event event) {
        DirtyStateReconciler reconciler = this.dirtyStateReconciler;
        if (reconciler == null) {
            this.dirtyStateReconciler = reconciler = this.createReconciler();
        }
        reconciler.scheduleFor(event);
    }

    protected class DirtyStateReconciler
    extends Job {
        protected final Queue<IResourceDescription.Delta> pendingChanges;

        public DirtyStateReconciler(ISchedulingRule rule) {
            this(rule, "Xtext Editor Reconciler");
        }

        public DirtyStateReconciler(ISchedulingRule rule, String name) {
            super(name);
            this.setRule(rule);
            this.pendingChanges = new ConcurrentLinkedQueue<IResourceDescription.Delta>();
        }

        public void scheduleFor(IResourceDescription.Event event) {
            this.cancel();
            this.pendingChanges.addAll((Collection<IResourceDescription.Delta>)event.getDeltas());
            this.schedule(this.getDelay());
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_DIRTY_STATE_RECONCILER;
        }

        protected IStatus run(final IProgressMonitor monitor) {
            DirtyStateEditorSupport.IDirtyStateEditorSupportClient myClient = HandlyDirtyStateEditorSupport.this.currentClient;
            if (myClient == null || monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            final HandlyXtextDocument document = (HandlyXtextDocument)myClient.getDocument();
            if (document == null) {
                return Status.OK_STATUS;
            }
            final boolean[] isReparseRequired = new boolean[1];
            final Pair<IResourceDescription.Event, Integer> event = this.mergePendingDeltas();
            final Collection<Resource> affectedResources = document.readOnly(new IUnitOfWork<Collection<Resource>, XtextResource>(){

                public Collection<Resource> exec(XtextResource resource) throws Exception {
                    if (resource == null || resource.getResourceSet() == null) {
                        return null;
                    }
                    Collection affectedResources = HandlyDirtyStateEditorSupport.this.collectAffectedResources(resource, (IResourceDescription.Event)event.getFirst());
                    if (monitor.isCanceled()) {
                        return Collections.emptySet();
                    }
                    isReparseRequired[0] = HandlyDirtyStateEditorSupport.this.isReparseRequired(resource, (IResourceDescription.Event)event.getFirst());
                    return affectedResources;
                }
            });
            if (monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            if (affectedResources != null && !affectedResources.isEmpty() || isReparseRequired[0]) {
                document.internalModify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource resource) throws Exception {
                        if (resource == null || resource.getResourceSet() == null) {
                            return;
                        }
                        ResourceSet resourceSet = resource.getResourceSet();
                        if (affectedResources != null) {
                            for (Resource affectedResource : affectedResources) {
                                affectedResource.unload();
                                resourceSet.getResources().remove((Object)affectedResource);
                            }
                        }
                        document.reconcile(true);
                    }
                });
            }
            int i = 0;
            while (i < (Integer)event.getSecond()) {
                this.pendingChanges.poll();
                ++i;
            }
            return Status.OK_STATUS;
        }

        protected Pair<IResourceDescription.Event, Integer> mergePendingDeltas() {
            LinkedHashMap uriToDelta = Maps.newLinkedHashMap();
            Iterator iter = this.pendingChanges.iterator();
            int size = 0;
            while (iter.hasNext()) {
                IResourceDescription.Delta delta = (IResourceDescription.Delta)iter.next();
                URI uri = delta.getUri();
                IResourceDescription.Delta prev = (IResourceDescription.Delta)uriToDelta.get(uri);
                if (prev == null) {
                    uriToDelta.put(uri, delta);
                } else if (prev.getOld() != delta.getNew()) {
                    uriToDelta.put(uri, HandlyDirtyStateEditorSupport.this.createDelta(delta, prev));
                } else {
                    uriToDelta.remove(uri);
                }
                ++size;
            }
            ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(uriToDelta.values());
            return Tuples.create((Object)event, (Object)size);
        }

        protected int getDelay() {
            return 500;
        }
    }
}

