/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import com.google.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.handly.document.DocumentChange;
import org.eclipse.handly.document.DocumentChangeOperation;
import org.eclipse.handly.document.IDocumentChange;
import org.eclipse.handly.document.UiDocumentChangeRunner;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.ISnapshotProvider;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.handly.xtext.ui.editor.IHandlyXtextDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.ui.editor.reconciler.ReplaceRegion;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class HandlyXtextDocument
extends XtextDocument
implements IHandlyXtextDocument {
    private final BooleanThreadLocal hasTopLevelModification = new BooleanThreadLocal();
    private ITextEditComposer composer2;
    private final ListenerList modelListeners2 = new ListenerList(1);
    private NonExpiringSnapshot reconciledSnapshot;
    private final ListenerList reconcilingListeners = new ListenerList(1);
    private final DocumentListener selfListener = new DocumentListener();
    private PendingChange pendingChange;
    private final Object pendingChangeLock = new Object();
    private HandlyXtextDocumentLocker locker;

    @Inject
    public HandlyXtextDocument(DocumentTokenSource tokenSource, ITextEditComposer composer) {
        super(tokenSource, composer);
        this.composer2 = composer;
    }

    public void setInput(XtextResource resource) {
        super.setInput(resource);
        this.reconciledSnapshot = this.getNonExpiringSnapshot();
        this.addDocumentListener(this.selfListener);
    }

    public void disposeInput() {
        this.removeDocumentListener(this.selfListener);
        this.getAndResetPendingChange();
        this.reconciledSnapshot = null;
        this.reconcilingListeners.clear();
        this.modelListeners2.clear();
        this.locker.dispose();
        this.setValidationJob(null);
        this.detachResource();
        super.disposeInput();
    }

    public ISnapshot getSnapshot() {
        return new DocumentSnapshot((IDocument)this);
    }

    @Override
    public ISnapshot getReconciledSnapshot() {
        return this.reconciledSnapshot.getWrappedSnapshot();
    }

    public void addReconcilingListener(IReconcilingListener listener) {
        this.reconcilingListeners.add((Object)listener);
    }

    public void removeReconcilingListener(IReconcilingListener listener) {
        this.reconcilingListeners.remove((Object)listener);
    }

    @Override
    public void addModificationListener(IHandlyXtextDocument.IModificationListener listener) {
        this.locker.addModificationListener(listener);
    }

    @Override
    public void removeModificationListener(IHandlyXtextDocument.IModificationListener listener) {
        this.locker.removeModificationListener(listener);
    }

    public void addModelListener(IXtextModelListener listener) {
        this.modelListeners2.add((Object)listener);
    }

    public void removeModelListener(IXtextModelListener listener) {
        this.modelListeners2.remove((Object)listener);
    }

    @Override
    public boolean needsReconciling() {
        return this.hasPendingChange();
    }

    @Override
    public void reconcile(boolean force) {
        this.reconcile(force, CancelIndicator.NullImpl);
    }

    public void reconcile(boolean force, CancelIndicator cancelIndicator) {
        this.reconcile(force, cancelIndicator, null);
    }

    public void reconcile(boolean force, CancelIndicator cancelIndicator, IXtextDocumentContentObserver.Processor processor) {
        if (cancelIndicator.isCanceled()) {
            return;
        }
        PendingChange change = this.getAndResetPendingChange();
        if (change == null && !force) {
            return;
        }
        T2MReconcilingUnitOfWork reconcilingUnitOfWork = new T2MReconcilingUnitOfWork(change, cancelIndicator);
        if (processor != null) {
            processor.process((IUnitOfWork)reconcilingUnitOfWork);
        } else {
            this.internalModify(reconcilingUnitOfWork);
        }
    }

    @Override
    public <T> T readOnly(IUnitOfWork<T, XtextResource> work) {
        return (T)super.readOnly(work);
    }

    @Override
    public <T> T modify(IUnitOfWork<T, XtextResource> work) {
        if (!((Boolean)this.hasTopLevelModification.get()).booleanValue()) {
            work = new M2TReconcilingUnitOfWork<T>(work);
        }
        return (T)this.internalModify(work);
    }

    @Override
    public IDocumentChange applyChange(IDocumentChange change) throws BadLocationException {
        DocumentChangeOperation operation = new DocumentChangeOperation((IDocument)this, change);
        UiDocumentChangeRunner runner = new UiDocumentChangeRunner(UiSynchronizer.DEFAULT, operation);
        return runner.run();
    }

    protected XtextDocument.XtextDocumentLocker createDocumentLocker() {
        this.locker = new HandlyXtextDocumentLocker();
        return this.locker;
    }

    protected void notifyModelListeners(XtextResource resource) {
        Object[] listeners = this.modelListeners2.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IXtextModelListener)listeners[i]).modelChanged(resource);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPendingChange() {
        Object object = this.pendingChangeLock;
        synchronized (object) {
            return this.pendingChange != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingChange getAndResetPendingChange() {
        PendingChange result;
        Object object = this.pendingChangeLock;
        synchronized (object) {
            result = this.pendingChange;
            this.pendingChange = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocumentChanged(DocumentEvent event) {
        Object object = this.pendingChangeLock;
        synchronized (object) {
            if (this.pendingChange == null) {
                this.pendingChange = new PendingChange();
            }
            this.pendingChange.add(event);
        }
    }

    private NonExpiringSnapshot getNonExpiringSnapshot() {
        try {
            return new NonExpiringSnapshot((ISnapshotProvider)this);
        }
        catch (CoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void reconciled(final NonExpiringSnapshot snapshot, final boolean forced, final CancelIndicator cancelIndicator) {
        this.reconciledSnapshot = snapshot;
        if (cancelIndicator.isCanceled()) {
            return;
        }
        this.locker.notify(new IUnitOfWork.Void<XtextResource>(){

            public void process(final XtextResource resource) throws Exception {
                Object[] listeners;
                Object[] objectArray = listeners = HandlyXtextDocument.this.reconcilingListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    final Object listener = objectArray[n2];
                    if (cancelIndicator.isCanceled()) {
                        return;
                    }
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            ((IReconcilingListener)listener).reconciled(resource, snapshot, forced);
                        }

                        public void handleException(Throwable exception) {
                        }
                    });
                    ++n2;
                }
            }
        });
    }

    private void internalReconcile(XtextResource resource, boolean force) throws Exception {
        this.reconcile(force, CancelIndicator.NullImpl, new InternalProcessor(resource));
    }

    private void detachResource() {
        this.internalModify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource resource) throws Exception {
                IReferableElementsUnloader unloader = resource.getUnloader();
                if (unloader != null) {
                    for (EObject content : resource.getContents()) {
                        unloader.unloadRoot(content);
                    }
                }
                resource.getContents().clear();
                resource.getErrors().clear();
                resource.getWarnings().clear();
                resource.setParseResult(null);
                resource.getResourceSet().getResources().clear();
            }
        });
    }

    private static class BooleanThreadLocal
    extends ThreadLocal<Boolean> {
        private BooleanThreadLocal() {
        }

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            HandlyXtextDocument.this.handleDocumentChanged(event);
        }
    }

    private class HandlyXtextDocumentLocker
    extends XtextDocument.XtextDocumentLocker {
        private final ListenerList modificationListeners;

        private HandlyXtextDocumentLocker() {
            super((XtextDocument)HandlyXtextDocument.this);
            this.modificationListeners = new ListenerList(1);
        }

        public void notify(IUnitOfWork.Void<XtextResource> notifyingUoW) {
            int writeHoldCount = this.downgradeWriteLock();
            try {
                try {
                    notifyingUoW.exec((Object)this.getState());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            }
            finally {
                this.regainWriteLock(writeHoldCount);
            }
        }

        public <T> T readOnly(IUnitOfWork<T, XtextResource> work) {
            if (this.isCanceled(work)) {
                return null;
            }
            return (T)super.readOnly(work);
        }

        public <T> T modify(IUnitOfWork<T, XtextResource> work) {
            if (this.isCanceled(work)) {
                return null;
            }
            this.aboutToModify(work);
            if (this.isCanceled(work)) {
                return null;
            }
            return (T)super.modify(work);
        }

        public void addModificationListener(IHandlyXtextDocument.IModificationListener listener) {
            this.modificationListeners.add((Object)listener);
        }

        public void removeModificationListener(IHandlyXtextDocument.IModificationListener listener) {
            this.modificationListeners.remove((Object)listener);
        }

        public void dispose() {
            this.modificationListeners.clear();
        }

        protected void beforeReadOnly(XtextResource resource, IUnitOfWork<?, XtextResource> work) {
            if (this.isCanceled(work)) {
                return;
            }
            if (this.rwLock.getReadHoldCount() == 1 && !this.rwLock.isWriteLockedByCurrentThread() && !(work instanceof IHandlyXtextDocument.IStraightReadingUnitOfWork)) {
                HandlyXtextDocument.this.updateContentBeforeRead();
            }
        }

        protected void afterModify(XtextResource resource, Object result, IUnitOfWork<?, XtextResource> work) {
            if (this.isCanceled(work)) {
                return;
            }
            super.afterModify(resource, result, work);
        }

        private int downgradeWriteLock() {
            if (this.rwLock.getWriteHoldCount() == 0) {
                throw new IllegalStateException();
            }
            if (this.rwLock.getReadHoldCount() > 0) {
                throw new IllegalStateException();
            }
            this.readLock.lock();
            int count = this.rwLock.getWriteHoldCount();
            int i = 0;
            while (i < count) {
                this.writeLock.unlock();
                ++i;
            }
            return count;
        }

        private void regainWriteLock(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException();
            }
            if (this.rwLock.getWriteHoldCount() > 0) {
                throw new IllegalStateException();
            }
            if (this.rwLock.getReadHoldCount() != 1) {
                throw new IllegalStateException();
            }
            this.readLock.unlock();
            int i = 0;
            while (i < count) {
                this.writeLock.lock();
                ++i;
            }
        }

        private void aboutToModify(final IUnitOfWork<?, XtextResource> work) {
            Object[] listeners;
            Object[] objectArray = listeners = this.modificationListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                final Object listener = objectArray[n2];
                if (this.isCanceled(work)) {
                    return;
                }
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        ((IHandlyXtextDocument.IModificationListener)listener).aboutToModify(work);
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                ++n2;
            }
        }

        private boolean isCanceled(IUnitOfWork<?, XtextResource> unitOfWork) {
            if (unitOfWork instanceof ICanceleableUnitOfWork) {
                return ((ICanceleableUnitOfWork)unitOfWork).isCanceled();
            }
            return false;
        }
    }

    private static interface ICanceleableUnitOfWork<R, P>
    extends IUnitOfWork<R, P> {
        public boolean isCanceled();
    }

    public static interface IReconcilingListener {
        public void reconciled(XtextResource var1, NonExpiringSnapshot var2, boolean var3);
    }

    private static class InternalProcessor
    implements IXtextDocumentContentObserver.Processor {
        private final XtextResource resource;

        public InternalProcessor(XtextResource resource) {
            this.resource = resource;
        }

        public <T> T process(IUnitOfWork<T, XtextResource> transaction) {
            try {
                return (T)transaction.exec((Object)this.resource);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
    }

    private class M2TReconcilingUnitOfWork<T>
    implements IUnitOfWork<T, XtextResource> {
        private final IUnitOfWork<T, XtextResource> work;
        private ISnapshot baseSnapshot;

        public M2TReconcilingUnitOfWork(IUnitOfWork<T, XtextResource> work) {
            this.work = work;
        }

        public T exec(XtextResource resource) throws Exception {
            HandlyXtextDocument.this.hasTopLevelModification.set(true);
            try {
                Object result;
                HandlyXtextDocument.this.internalReconcile(resource, false);
                this.baseSnapshot = HandlyXtextDocument.this.getReconciledSnapshot();
                try {
                    EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
                    HandlyXtextDocument.this.composer2.beginRecording((Resource)resource);
                    result = this.work.exec((Object)resource);
                    TextEdit edit = HandlyXtextDocument.this.composer2.endRecording();
                    if (edit != null) {
                        DocumentChange change = new DocumentChange(edit);
                        change.setBase(this.baseSnapshot);
                        if (this.work instanceof IHandlyXtextDocument.IUndoableUnitOfWork) {
                            change.setStyle(1);
                        } else {
                            change.setStyle(0);
                        }
                        IDocumentChange undoChange = HandlyXtextDocument.this.applyChange((IDocumentChange)change);
                        if (this.work instanceof IHandlyXtextDocument.IUndoableUnitOfWork) {
                            ((IHandlyXtextDocument.IUndoableUnitOfWork)this.work).acceptUndoChange(undoChange);
                        }
                    }
                }
                catch (Exception e) {
                    Activator.log(Activator.createErrorStatus(e.getMessage(), e));
                    resource.reparse(HandlyXtextDocument.this.reconciledSnapshot.getContents());
                    throw e;
                }
                HandlyXtextDocument.this.internalReconcile(resource, false);
                Object object = result;
                return (T)object;
            }
            finally {
                HandlyXtextDocument.this.hasTopLevelModification.remove();
            }
        }
    }

    private class PendingChange {
        private NonExpiringSnapshot snapshotToReconcile;
        private ReplaceRegion replaceRegionToReconcile;

        private PendingChange() {
        }

        public NonExpiringSnapshot getSnapshotToReconcile() {
            return this.snapshotToReconcile;
        }

        public ReplaceRegion getReplaceRegionToReconcile() {
            return this.replaceRegionToReconcile;
        }

        public void add(DocumentEvent event) {
            this.snapshotToReconcile = HandlyXtextDocument.this.getNonExpiringSnapshot();
            ReplaceRegion replaceRegion = new ReplaceRegion(event.getOffset(), event.getLength(), event.getText());
            if (this.replaceRegionToReconcile == null) {
                this.replaceRegionToReconcile = replaceRegion;
            } else {
                this.replaceRegionToReconcile.mergeWith(replaceRegion, (Object)this.snapshotToReconcile.getContents());
            }
        }
    }

    private class T2MReconcilingUnitOfWork
    implements ICanceleableUnitOfWork<Object, XtextResource> {
        private final PendingChange change;
        private final CancelIndicator cancelIndicator;

        public T2MReconcilingUnitOfWork(PendingChange change, CancelIndicator cancelIndicator) {
            this.change = change;
            this.cancelIndicator = cancelIndicator;
        }

        @Override
        public boolean isCanceled() {
            return this.cancelIndicator.isCanceled();
        }

        public Object exec(XtextResource resource) throws Exception {
            if (this.change == null) {
                NonExpiringSnapshot snapshot = HandlyXtextDocument.this.reconciledSnapshot;
                resource.reparse(snapshot.getContents());
                HandlyXtextDocument.this.reconciled(snapshot, true, this.cancelIndicator);
            } else {
                NonExpiringSnapshot snapshot = this.change.getSnapshotToReconcile();
                ReplaceRegion replaceRegion = this.change.getReplaceRegionToReconcile();
                boolean reconciled = false;
                try {
                    resource.update(replaceRegion.getOffset(), replaceRegion.getLength(), replaceRegion.getText());
                    reconciled = true;
                }
                catch (Exception e) {
                    Activator.log(Activator.createErrorStatus(e.getMessage(), e));
                    try {
                        resource.reparse(snapshot.getContents());
                        reconciled = true;
                    }
                    catch (Exception e2) {
                        Activator.log(Activator.createErrorStatus(e2.getMessage(), e2));
                        resource.reparse(HandlyXtextDocument.this.reconciledSnapshot.getContents());
                        throw e2;
                    }
                }
                if (reconciled) {
                    HandlyXtextDocument.this.reconciled(snapshot, false, this.cancelIndicator);
                }
            }
            return null;
        }
    }
}

