/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.buffer.IDocumentBuffer;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceFileFactory;
import org.eclipse.handly.model.impl.IWorkingCopyBuffer;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.ui.texteditor.TextEditorBuffer;
import org.eclipse.handly.util.TextRange;
import org.eclipse.handly.xtext.ui.editor.XtextWorkingCopyBuffer;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class HandlyXtextEditorCallback
extends IXtextEditorCallback.NullImpl {
    @Inject
    private ISourceFileFactory sourceFileFactory;
    private Map<XtextEditor, SourceFile> workingCopies = new HashMap<XtextEditor, SourceFile>();
    private Map<XtextEditor, ISelectionChangedListener> selectionListeners = new HashMap<XtextEditor, ISelectionChangedListener>();

    public void afterCreatePartControl(XtextEditor editor) {
        this.setHighlightRange(editor, editor.getSelectionProvider().getSelection());
        this.registerSelectionListener(editor);
    }

    public void beforeDispose(XtextEditor editor) {
        this.deregisterSelectionListener(editor);
        this.discardWorkingCopy(editor);
    }

    public void beforeSetInput(XtextEditor editor) {
        this.discardWorkingCopy(editor);
    }

    public void afterSetInput(XtextEditor editor) {
        this.createWorkingCopy(editor);
        this.setHighlightRange(editor, editor.getSelectionProvider().getSelection());
    }

    protected void afterSelectionChange(XtextEditor editor, ISelection selection) {
        this.setHighlightRange(editor, selection);
    }

    protected void setHighlightRange(XtextEditor editor, ISelection selection) {
        int position;
        if (selection == null) {
            return;
        }
        SourceFile sourceFile = this.getWorkingCopy(editor);
        if (sourceFile == null) {
            return;
        }
        ISourceElement selectedElement = null;
        if (selection instanceof ITextSelection && (position = ((ITextSelection)selection).getOffset()) >= 0) {
            try {
                sourceFile.reconcile(false, null);
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
                editor.resetHighlightRange();
                return;
            }
            selectedElement = sourceFile.getElementAt(position, null);
            if (sourceFile.equals((Object)selectedElement)) {
                selectedElement = null;
            }
        }
        if (selectedElement == null || !selectedElement.exists()) {
            editor.resetHighlightRange();
        } else {
            TextRange r;
            try {
                r = selectedElement.getSourceElementInfo().getFullRange();
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
                editor.resetHighlightRange();
                return;
            }
            editor.setHighlightRange(r.getOffset(), r.getLength(), false);
        }
    }

    protected SourceFile getSourceFile(XtextEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return (SourceFile)this.sourceFileFactory.getSourceFile(file);
    }

    protected final SourceFile getWorkingCopy(XtextEditor editor) {
        return this.workingCopies.get(editor);
    }

    private void registerSelectionListener(final XtextEditor editor) {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HandlyXtextEditorCallback.this.afterSelectionChange(editor, event.getSelection());
            }
        };
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(listener);
        } else {
            selectionProvider.addSelectionChangedListener(listener);
        }
        this.selectionListeners.put(editor, listener);
    }

    private void deregisterSelectionListener(XtextEditor editor) {
        ISelectionChangedListener listener = this.selectionListeners.remove(editor);
        if (listener != null) {
            ISelectionProvider selectionProvider = editor.getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(listener);
            } else {
                selectionProvider.removeSelectionChangedListener(listener);
            }
        }
    }

    private void createWorkingCopy(XtextEditor editor) {
        SourceFile sourceFile = this.getSourceFile(editor);
        if (sourceFile != null && !sourceFile.isWorkingCopy() && sourceFile.getParent().exists()) {
            try {
                XtextWorkingCopyBuffer buffer = new XtextWorkingCopyBuffer(sourceFile, (IDocumentBuffer)new TextEditorBuffer((ITextEditor)editor));
                try {
                    sourceFile.becomeWorkingCopy((IWorkingCopyBuffer)buffer, null);
                    this.workingCopies.put(editor, sourceFile);
                }
                finally {
                    buffer.dispose();
                }
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        }
    }

    private void discardWorkingCopy(XtextEditor editor) {
        SourceFile sourceFile = this.workingCopies.remove(editor);
        if (sourceFile != null) {
            sourceFile.discardWorkingCopy();
        }
    }
}

