/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.xtext.ui.editor.HandlyXtextDocument;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.ISourceViewerExtension4;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.reconciler.XtextReconciler;
import org.eclipse.xtext.util.CancelIndicator;

public class HandlyXtextReconciler
extends Job
implements IReconciler {
    public static final Object FAMILY_RECONCILER = XtextReconciler.class.getName();
    private boolean isInstalled;
    private boolean shouldInstallCompletionListener;
    private volatile boolean paused;
    private ITextViewer viewer;
    private final TextInputListener textInputListener = new TextInputListener();
    private final DocumentListener documentListener = new DocumentListener();
    private int delay = 500;

    public HandlyXtextReconciler() {
        super("Xtext Editor Reconciler");
        this.setPriority(20);
        this.setSystem(true);
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void install(ITextViewer textViewer) {
        if (!this.isInstalled) {
            this.viewer = textViewer;
            IDocument document0 = this.viewer.getDocument();
            this.viewer.addTextInputListener((ITextInputListener)this.textInputListener);
            IDocument document = this.viewer.getDocument();
            if (document instanceof HandlyXtextDocument && document == document0) {
                ((HandlyXtextDocument)document).addXtextDocumentContentObserver(this.documentListener);
            }
            if (this.viewer instanceof ISourceViewerExtension4) {
                ContentAssistantFacade facade = ((ISourceViewerExtension4)this.viewer).getContentAssistantFacade();
                if (facade == null) {
                    this.shouldInstallCompletionListener = true;
                } else {
                    facade.addCompletionListener((ICompletionListener)this.documentListener);
                }
            }
            this.isInstalled = true;
        }
    }

    public void uninstall() {
        if (this.isInstalled) {
            this.viewer.removeTextInputListener((ITextInputListener)this.textInputListener);
            IDocument document = this.viewer.getDocument();
            if (document instanceof HandlyXtextDocument) {
                ((HandlyXtextDocument)document).removeXtextDocumentContentObserver(this.documentListener);
            }
            if (this.viewer instanceof ISourceViewerExtension4) {
                ContentAssistantFacade facade = ((ISourceViewerExtension4)this.viewer).getContentAssistantFacade();
                facade.removeCompletionListener((ICompletionListener)this.documentListener);
            }
            this.isInstalled = false;
        }
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return null;
    }

    public boolean belongsTo(Object family) {
        return FAMILY_RECONCILER.equals(family);
    }

    protected IStatus run(final IProgressMonitor monitor) {
        if (monitor.isCanceled() || this.paused) {
            return Status.CANCEL_STATUS;
        }
        IDocument document = this.viewer.getDocument();
        if (document instanceof HandlyXtextDocument) {
            ((HandlyXtextDocument)document).reconcile(false, new CancelIndicator(){

                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            });
        }
        return Status.OK_STATUS;
    }

    private void handleDocumentChanged(DocumentEvent event) {
        this.cancel();
        this.schedule(this.delay);
    }

    private void pause() {
        this.paused = true;
    }

    private void resume() {
        this.paused = false;
        this.schedule(this.delay);
    }

    private class DocumentListener
    implements IXtextDocumentContentObserver,
    ICompletionListener {
        private volatile boolean sessionStarted = false;

        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            HandlyXtextReconciler.this.handleDocumentChanged(event);
        }

        public void performNecessaryUpdates(IXtextDocumentContentObserver.Processor processor) {
            IDocument document = HandlyXtextReconciler.this.viewer.getDocument();
            if (document instanceof HandlyXtextDocument && !HandlyXtextReconciler.this.paused) {
                ((HandlyXtextDocument)document).reconcile(false, CancelIndicator.NullImpl, processor);
            }
            if (this.sessionStarted && !HandlyXtextReconciler.this.paused) {
                HandlyXtextReconciler.this.pause();
            }
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            this.sessionStarted = true;
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            this.sessionStarted = false;
            HandlyXtextReconciler.this.resume();
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    }

    private class TextInputListener
    implements ITextInputListener {
        private TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput instanceof HandlyXtextDocument) {
                ((HandlyXtextDocument)oldInput).removeXtextDocumentContentObserver(HandlyXtextReconciler.this.documentListener);
                HandlyXtextReconciler.this.cancel();
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput instanceof HandlyXtextDocument) {
                ((HandlyXtextDocument)newInput).addXtextDocumentContentObserver(HandlyXtextReconciler.this.documentListener);
                HandlyXtextReconciler.this.schedule(HandlyXtextReconciler.this.delay);
            }
            if (HandlyXtextReconciler.this.shouldInstallCompletionListener) {
                ContentAssistantFacade facade = ((ISourceViewerExtension4)HandlyXtextReconciler.this.viewer).getContentAssistantFacade();
                if (facade != null) {
                    facade.addCompletionListener((ICompletionListener)HandlyXtextReconciler.this.documentListener);
                }
                HandlyXtextReconciler.this.shouldInstallCompletionListener = false;
            }
        }
    }
}

