/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.IDocumentBuffer;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.model.impl.IWorkingCopyBuffer;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.xtext.ui.editor.HandlyXtextDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.resource.XtextResource;

public final class XtextWorkingCopyBuffer
implements IWorkingCopyBuffer {
    private final IDocumentBuffer delegate;
    private final HandlyXtextDocument.IReconcilingListener reconcilingListener;
    private int refCount = 1;

    public XtextWorkingCopyBuffer(final SourceFile workingCopy, IDocumentBuffer delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        boolean success = false;
        try {
            if (workingCopy == null) {
                throw new IllegalArgumentException();
            }
            IDocument document = delegate.getDocument();
            if (!(document instanceof HandlyXtextDocument)) {
                throw new IllegalArgumentException();
            }
            this.delegate = delegate;
            this.reconcilingListener = new HandlyXtextDocument.IReconcilingListener(){

                @Override
                public void reconciled(XtextResource resource, NonExpiringSnapshot snapshot, boolean forced) {
                    try {
                        workingCopy.getReconcileOperation().reconcile((Object)resource, snapshot, forced);
                    }
                    catch (CoreException e) {
                        Activator.log(e.getStatus());
                    }
                }
            };
            ((HandlyXtextDocument)document).addReconcilingListener(this.reconcilingListener);
            success = true;
        }
        finally {
            if (!success) {
                delegate.dispose();
            }
        }
    }

    public ISnapshot getSnapshot() {
        return this.delegate.getSnapshot();
    }

    public IBufferChange applyChange(IBufferChange change, IProgressMonitor pm) throws CoreException {
        return this.delegate.applyChange(change, pm);
    }

    public void setContents(String contents) {
        this.delegate.setContents(contents);
    }

    public boolean hasUnsavedChanges() {
        return this.delegate.hasUnsavedChanges();
    }

    public boolean mustSaveChanges() {
        return this.delegate.mustSaveChanges();
    }

    public void save(boolean overwrite, IProgressMonitor pm) throws CoreException {
        this.delegate.save(overwrite, pm);
    }

    public boolean needsReconciling() {
        return this.getDocument().needsReconciling();
    }

    public void reconcile(boolean force, IProgressMonitor pm) throws CoreException {
        this.getDocument().reconcile(force);
    }

    public synchronized void addRef() {
        ++this.refCount;
    }

    public synchronized void release() {
        if (--this.refCount == 0) {
            try {
                if (this.reconcilingListener != null) {
                    this.getDocument().removeReconcilingListener(this.reconcilingListener);
                }
            }
            finally {
                this.delegate.dispose();
            }
        }
    }

    public void dispose() {
        this.release();
    }

    private HandlyXtextDocument getDocument() {
        return (HandlyXtextDocument)this.delegate.getDocument();
    }
}

