/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.document;

import org.eclipse.handly.document.DocumentChangeOperation;
import org.eclipse.handly.document.IDocumentChange;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;

public final class UiDocumentChangeRunner {
    private final UiSynchronizer synchronizer;
    private final DocumentChangeOperation operation;

    public UiDocumentChangeRunner(UiSynchronizer synchronizer, DocumentChangeOperation operation) {
        this.synchronizer = synchronizer;
        if (this.synchronizer == null) {
            throw new IllegalArgumentException();
        }
        this.operation = operation;
        if (this.operation == null) {
            throw new IllegalArgumentException();
        }
    }

    public IDocumentChange run() throws BadLocationException {
        Thread synchronizerThread;
        Thread callerThread = Thread.currentThread();
        if (callerThread.equals(synchronizerThread = this.synchronizer.getThread())) {
            return this.operation.execute();
        }
        final IDocumentChange[] undoChange = new IDocumentChange[1];
        final Throwable[] exception = new Throwable[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    undoChange[0] = UiDocumentChangeRunner.this.operation.execute();
                }
                catch (Throwable e) {
                    exception[0] = e;
                }
            }
        };
        this.synchronizer.syncExec(runnable);
        if (exception[0] != null) {
            Throwable e = exception[0];
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof BadLocationException) {
                throw (BadLocationException)e;
            }
            throw new AssertionError((Object)e);
        }
        return undoChange[0];
    }
}

