/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.impl.IWorkingCopyBuffer;
import org.eclipse.handly.model.impl.IWorkingCopyReconciler;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;

public final class DelegatingWorkingCopyBuffer
implements IWorkingCopyBuffer {
    private final IBuffer delegate;
    private final IWorkingCopyReconciler reconciler;
    private final Object reconcilingLock = new Object();
    private ISnapshot reconciledSnapshot;
    private int refCount = 1;

    public DelegatingWorkingCopyBuffer(IBuffer delegate, IWorkingCopyReconciler reconciler) {
        this.delegate = delegate;
        if (this.delegate == null) {
            throw new IllegalArgumentException();
        }
        boolean success = false;
        try {
            this.reconciler = reconciler;
            if (this.reconciler == null) {
                throw new IllegalArgumentException();
            }
            success = true;
        }
        finally {
            if (!success) {
                delegate.dispose();
            }
        }
    }

    @Override
    public ISnapshot getSnapshot() {
        return this.delegate.getSnapshot();
    }

    @Override
    public IBufferChange applyChange(IBufferChange change, IProgressMonitor monitor) throws CoreException {
        return this.delegate.applyChange(change, monitor);
    }

    @Override
    public void setContents(String contents) {
        this.delegate.setContents(contents);
    }

    @Override
    public boolean hasUnsavedChanges() {
        return this.delegate.hasUnsavedChanges();
    }

    @Override
    public boolean mustSaveChanges() {
        return this.delegate.mustSaveChanges();
    }

    @Override
    public void save(boolean overwrite, IProgressMonitor monitor) throws CoreException {
        this.delegate.save(overwrite, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsReconciling() {
        Object object = this.reconcilingLock;
        synchronized (object) {
            try {
                return !this.getSnapshot().isEqualTo(this.reconciledSnapshot);
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconcile(boolean force, IProgressMonitor monitor) throws CoreException {
        Object object = this.reconcilingLock;
        synchronized (object) {
            boolean needsReconciling = this.needsReconciling();
            if (needsReconciling || force) {
                NonExpiringSnapshot snapshot = new NonExpiringSnapshot(this.delegate);
                this.reconciler.reconcile(snapshot, !needsReconciling, monitor);
                this.reconciledSnapshot = snapshot.getWrappedSnapshot();
            }
        }
    }

    @Override
    public synchronized void addRef() {
        ++this.refCount;
    }

    @Override
    public synchronized void release() {
        if (--this.refCount == 0) {
            this.delegate.dispose();
        }
    }

    @Override
    public void dispose() {
        this.release();
    }
}

