/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.HandleManager;

public abstract class Handle
extends PlatformObject
implements IHandle {
    protected static final Body NO_BODY = new Body();
    protected final Handle parent;
    protected final String name;

    public Handle(Handle parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public IHandle getParent() {
        return this.parent;
    }

    @Override
    public IHandle getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    @Override
    public <T extends IHandle> T getAncestor(Class<T> ancestorType) {
        if (this.parent == null) {
            return null;
        }
        if (ancestorType.isInstance(this.parent)) {
            return (T)((IHandle)ancestorType.cast(this.parent));
        }
        return this.parent.getAncestor(ancestorType);
    }

    @Override
    public IPath getPath() {
        return this.getResource() == null ? null : this.getResource().getFullPath();
    }

    @Override
    public boolean exists() {
        if (this.findBody() != null) {
            return true;
        }
        try {
            this.validateExistence();
            return true;
        }
        catch (CoreException e) {
            return false;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Handle)) {
            return false;
        }
        Handle other = (Handle)obj;
        if (!this.getElementType().equals(other.getElementType())) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public IHandle[] getChildren() throws CoreException {
        return this.getBody().getChildren();
    }

    @Override
    public <T extends IHandle> T[] getChildren(Class<T> childType) throws CoreException {
        IHandle[] children = this.getChildren();
        ArrayList<IHandle> list = new ArrayList<IHandle>(children.length);
        IHandle[] iHandleArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IHandle child = iHandleArray[n2];
            if (childType.isInstance(child)) {
                list.add((IHandle)childType.cast(child));
            }
            ++n2;
        }
        IHandle[] result = (IHandle[])Array.newInstance(childType, list.size());
        return list.toArray(result);
    }

    public Body findBody() {
        return this.getHandleManager().get(this);
    }

    public Body peekAtBody() {
        return this.getHandleManager().peek(this);
    }

    public boolean close() {
        this.getHandleManager().removeBodyAndChildren(this);
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringBody(0, buffer, NO_BODY, true);
        return buffer.toString();
    }

    public String toStringWithAncestors() {
        return this.toStringWithAncestors(true);
    }

    public String toStringWithAncestors(boolean showResolvedInfo) {
        StringBuffer buffer = new StringBuffer();
        this.toStringBody(0, buffer, NO_BODY, showResolvedInfo);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    public Body toStringBody(int tab, StringBuffer buffer) {
        Body body = this.peekAtBody();
        this.toStringBody(tab, buffer, body, true);
        return body;
    }

    protected void toStringAncestors(StringBuffer buffer) {
        if (this.parent != null && this.parent.getParent() != null) {
            buffer.append(" [in ");
            this.parent.toStringBody(0, buffer, NO_BODY, false);
            this.parent.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toString(int tab, StringBuffer buffer) {
        Body body = this.toStringBody(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, body);
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Body body) {
        if (body == null) {
            return;
        }
        IHandle[] children = body.getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((Handle)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    protected void toStringBody(int tab, StringBuffer buffer, Body body, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        this.toStringName(buffer);
        if (body == null) {
            buffer.append(" (not open)");
        }
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.getName());
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    protected Object getElementType() {
        return this.getClass();
    }

    protected abstract HandleManager getHandleManager();

    protected abstract void validateExistence() throws CoreException;

    protected abstract void buildStructure(Body var1, Map<IHandle, Body> var2) throws CoreException;

    protected final Body getBody() throws CoreException {
        Body body = this.findBody();
        if (body != null) {
            return body;
        }
        return this.openWhenClosed(this.newBody());
    }

    protected Body newBody() {
        return new Body();
    }

    protected final Body openWhenClosed(Body body) throws CoreException {
        HandleManager handleManager = this.getHandleManager();
        boolean hadTemporaryCache = handleManager.hasTemporaryCache();
        try {
            Map<IHandle, Body> newElements = handleManager.getTemporaryCache();
            this.generateBodies(body, newElements);
            if (body == null) {
                body = newElements.get(this);
            }
            if (body == null) {
                throw new CoreException(Activator.createErrorStatus("The element does not exist: " + this.toString(), null));
            }
            if (!hadTemporaryCache) {
                handleManager.put(this, newElements);
            }
        }
        finally {
            if (!hadTemporaryCache) {
                handleManager.resetTemporaryCache();
            }
        }
        return body;
    }

    protected Handle getOpenableParent() {
        return this.parent;
    }

    private void generateBodies(Body body, Map<IHandle, Body> newElements) throws CoreException {
        Handle openableParent = this.getOpenableParent();
        if (openableParent != null && openableParent.findBody() == null) {
            openableParent.generateBodies(openableParent.newBody(), newElements);
        }
        if (body != null) {
            this.validateExistence();
            newElements.put(this, body);
            try {
                this.buildStructure(body, newElements);
            }
            catch (CoreException e) {
                newElements.remove(this);
                throw e;
            }
        }
    }
}

