/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.IHandleDelta;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.HandleDelta;

public class HandleDeltaBuilder {
    private final IHandle element;
    private final int maxDepth;
    private Map<IHandle, Body> oldBodies;
    private Map<IHandle, ListItem> oldPositions;
    private Map<IHandle, ListItem> newPositions;
    private Set<IHandle> added;
    private Set<IHandle> removed;
    private HandleDelta delta;

    public HandleDeltaBuilder(IHandle element) {
        this(element, Integer.MAX_VALUE);
    }

    public HandleDeltaBuilder(IHandle element, int maxDepth) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordBody(element, 0);
    }

    public final void buildDelta() {
        this.delta = new HandleDelta(this.element);
        this.recordNewPositions(this.element, 0);
        this.findAdditions(this.element, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.element, 0);
        HandleDeltaBuilder.trimDelta(this.delta);
    }

    public final HandleDelta getDelta() {
        return this.delta;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Built delta:\n");
        buffer.append(this.delta == null ? "<null>" : this.delta.toString());
        return buffer.toString();
    }

    protected void findContentChange(Body newBody, Body oldBody, IHandle element) {
        newBody.findContentChange(oldBody, element, this.delta);
    }

    private void initialize() {
        this.oldBodies = new HashMap<IHandle, Body>(20);
        this.oldPositions = new HashMap<IHandle, ListItem>(20);
        this.newPositions = new HashMap<IHandle, ListItem>(20);
        this.oldPositions.put(this.element, new ListItem(null, null));
        this.newPositions.put(this.element, new ListItem(null, null));
        this.added = new HashSet<IHandle>(5);
        this.removed = new HashSet<IHandle>(5);
    }

    private void recordBody(IHandle element, int depth) {
        Body body;
        if (depth >= this.maxDepth) {
            return;
        }
        try {
            body = ((Handle)element).getBody();
        }
        catch (CoreException e) {
            return;
        }
        this.oldBodies.put(element, body);
        IHandle[] children = body.getChildren();
        if (children != null) {
            this.insertPositions(children, false);
            IHandle[] iHandleArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IHandle child = iHandleArray[n2];
                this.recordBody(child, depth + 1);
                ++n2;
            }
        }
    }

    private void recordNewPositions(IHandle newElement, int depth) {
        Body body;
        if (depth >= this.maxDepth) {
            return;
        }
        try {
            body = ((Handle)newElement).getBody();
        }
        catch (CoreException e) {
            return;
        }
        IHandle[] children = body.getChildren();
        if (children != null) {
            this.insertPositions(children, true);
            IHandle[] iHandleArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IHandle child = iHandleArray[n2];
                this.recordNewPositions(child, depth + 1);
                ++n2;
            }
        }
    }

    private void insertPositions(IHandle[] elements, boolean isNew) {
        int length = elements.length;
        IHandle previous = null;
        IHandle current = null;
        IHandle next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            IHandle iHandle = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.newPositions.put(current, new ListItem(previous, next));
            } else {
                this.oldPositions.put(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private void findAdditions(IHandle newElement, int depth) {
        Body oldBody = this.getOldBody(newElement);
        if (oldBody == null && depth < this.maxDepth) {
            this.delta.insertAdded(newElement);
            this.added(newElement);
        } else {
            this.removeOldBody(newElement);
        }
        if (depth >= this.maxDepth) {
            this.delta.insertChanged(newElement, 1);
            return;
        }
        if (oldBody != null) {
            Body newBody;
            try {
                newBody = ((Handle)newElement).getBody();
            }
            catch (CoreException e) {
                return;
            }
            this.findContentChange(newBody, oldBody, newElement);
            IHandle[] children = newBody.getChildren();
            if (children != null) {
                IHandle[] iHandleArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IHandle child = iHandleArray[n2];
                    this.findAdditions(child, depth + 1);
                    ++n2;
                }
            }
        }
    }

    private void findDeletions() {
        for (IHandle element : this.oldBodies.keySet()) {
            this.delta.insertRemoved(element);
            this.removed(element);
        }
    }

    private void findChangesInPositioning(IHandle element, int depth) {
        Body body;
        if (depth >= this.maxDepth || this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            this.delta.insertChanged(element, 16);
        }
        try {
            body = ((Handle)element).getBody();
        }
        catch (CoreException e) {
            return;
        }
        IHandle[] children = body.getChildren();
        if (children != null) {
            IHandle[] iHandleArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IHandle child = iHandleArray[n2];
                this.findChangesInPositioning(child, depth + 1);
                ++n2;
            }
        }
    }

    private static void trimDelta(HandleDelta delta) {
        if (delta.getKind() == 2) {
            IHandleDelta[] children;
            IHandleDelta[] iHandleDeltaArray = children = delta.getAffectedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IHandleDelta child = iHandleDeltaArray[n2];
                delta.removeAffectedChild((HandleDelta)child);
                ++n2;
            }
        } else {
            IHandleDelta[] children;
            IHandleDelta[] iHandleDeltaArray = children = delta.getAffectedChildren();
            int n = children.length;
            int n3 = 0;
            while (n3 < n) {
                IHandleDelta child = iHandleDeltaArray[n3];
                HandleDeltaBuilder.trimDelta((HandleDelta)child);
                ++n3;
            }
        }
    }

    private void added(IHandle element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removed(IHandle element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private boolean isPositionedCorrectly(IHandle element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        IHandle oldPrevious = oldListItem.previous;
        IHandle newPrevious = newListItem.previous;
        if (oldPrevious == null) {
            return newPrevious == null;
        }
        return oldPrevious.equals(newPrevious);
    }

    private Body getOldBody(IHandle element) {
        return this.oldBodies.get(element);
    }

    private void removeOldBody(IHandle element) {
        this.oldBodies.remove(element);
    }

    private ListItem getOldPosition(IHandle element) {
        return this.oldPositions.get(element);
    }

    private ListItem getNewPosition(IHandle element) {
        return this.newPositions.get(element);
    }

    private static class ListItem {
        public IHandle previous;
        public IHandle next;

        public ListItem(IHandle previous, IHandle next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

