/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.IWorkingCopyBuffer;
import org.eclipse.handly.model.impl.Messages;
import org.eclipse.handly.model.impl.SourceElement;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.handly.model.impl.WorkingCopyInfo;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.ISnapshotProvider;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.snapshot.TextFileSnapshot;
import org.eclipse.handly.util.TextRange;

public abstract class SourceFile
extends SourceElement
implements ISourceFile {
    private static final ThreadLocal<AstHolder> AST_HOLDER = new ThreadLocal();
    private static final ThreadLocal<WcCreation> WC_CREATION = new ThreadLocal();
    protected final IFile file;

    public SourceFile(Handle parent, IFile file) {
        super(parent, file.getName());
        this.file = file;
    }

    @Override
    public final IResource getResource() {
        return this.file;
    }

    @Override
    public final IFile getFile() {
        return this.file;
    }

    @Override
    public final SourceFile getSourceFile() {
        return this;
    }

    @Override
    public final ISourceElement getElementAt(int position, ISnapshot base) {
        try {
            return SourceFile.getElementAt(this, position, base);
        }
        catch (CoreException coreException) {
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public final IBuffer openBuffer(boolean create, IProgressMonitor monitor) throws CoreException {
        WorkingCopyInfo info = this.getWorkingCopyInfo();
        if (info == null) {
            if (!create && ITextFileBufferManager.DEFAULT.getTextFileBuffer(this.file.getFullPath(), LocationKind.IFILE) == null) {
                return null;
            }
            return new TextFileBuffer(this.file, ITextFileBufferManager.DEFAULT, monitor);
        }
        try {
            IWorkingCopyBuffer buffer = info.getBuffer();
            buffer.addRef();
            IWorkingCopyBuffer iWorkingCopyBuffer = buffer;
            return iWorkingCopyBuffer;
        }
        finally {
            this.discardWorkingCopyInfo();
        }
    }

    @Override
    public final IBuffer openBuffer(IProgressMonitor monitor) throws CoreException {
        return this.openBuffer(true, monitor);
    }

    public final void becomeWorkingCopy(IWorkingCopyBuffer buffer, IProgressMonitor monitor) throws CoreException {
        if (this.createWorkingCopyInfo(buffer)) {
            boolean success = false;
            try {
                WC_CREATION.set(WcCreation.IN_PROGRESS);
                this.reconcile(false, monitor);
                success = true;
            }
            finally {
                WcCreation creationState = WC_CREATION.get();
                WC_CREATION.set(null);
                if (!success && this.discardWorkingCopyInfo() && creationState == WcCreation.FINISHED) {
                    this.workingCopyModeChanged();
                }
            }
        }
    }

    public final boolean discardWorkingCopy() {
        if (this.discardWorkingCopyInfo()) {
            this.workingCopyModeChanged();
            return true;
        }
        return false;
    }

    @Override
    public final boolean isWorkingCopy() {
        return this.peekAtWorkingCopyInfo() != null;
    }

    @Override
    public final boolean needsReconciling() {
        WorkingCopyInfo info = this.getWorkingCopyInfo();
        if (info == null) {
            return false;
        }
        try {
            boolean bl = info.getBuffer().needsReconciling();
            return bl;
        }
        finally {
            this.discardWorkingCopy();
        }
    }

    @Override
    public final void reconcile(boolean force, IProgressMonitor monitor) throws CoreException {
        WorkingCopyInfo info = this.getWorkingCopyInfo();
        if (info == null) {
            return;
        }
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            info.getBuffer().reconcile(force, monitor);
        }
        finally {
            this.discardWorkingCopyInfo();
        }
    }

    @Override
    public final boolean close() {
        if (this.isWorkingCopy()) {
            return false;
        }
        return super.close();
    }

    public ReconcileOperation getReconcileOperation() {
        return new ReconcileOperation();
    }

    protected void workingCopyModeChanged() {
    }

    @Override
    protected SourceElementBody newBody() {
        return new SourceElementBody();
    }

    @Override
    protected void validateExistence() throws CoreException {
        if (!this.isWorkingCopy() && !this.file.exists()) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format(Messages.SourceFile_File_does_not_exist__0, this.file.getFullPath().makeRelative()), null));
        }
    }

    @Override
    protected final void buildStructure(Body body, Map<IHandle, Body> newElements) throws CoreException {
        AstHolder astHolder = AST_HOLDER.get();
        if (astHolder == null) {
            NonExpiringSnapshot snapshot = new NonExpiringSnapshot(new ISnapshotProvider(){

                @Override
                public ISnapshot getSnapshot() throws CoreException {
                    return new TextFileSnapshot(SourceFile.this.getFile());
                }
            });
            Object ast = this.createStructuralAst(snapshot.getContents());
            astHolder = new AstHolder(ast, snapshot);
        }
        SourceElementBody thisBody = (SourceElementBody)body;
        String source = astHolder.snapshot.getContents();
        ISnapshot snapshot = astHolder.snapshot.getWrappedSnapshot();
        this.buildStructure(thisBody, newElements, astHolder.ast, source);
        thisBody.setFullRange(new TextRange(0, source.length()));
        SourceFile.setSnapshot(thisBody, snapshot, newElements);
    }

    protected abstract Object createStructuralAst(String var1) throws CoreException;

    protected abstract void buildStructure(SourceElementBody var1, Map<IHandle, Body> var2, Object var3, String var4);

    protected boolean shouldRebuildStructureIfForced() {
        return false;
    }

    private static void setSnapshot(SourceElementBody body, ISnapshot snapshot, Map<IHandle, Body> newElements) {
        body.setSnapshot(snapshot);
        ISourceConstruct[] iSourceConstructArray = body.getChildren();
        int n = iSourceConstructArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceConstruct child = iSourceConstructArray[n2];
            SourceFile.setSnapshot((SourceElementBody)newElements.get(child), snapshot, newElements);
            ++n2;
        }
    }

    private boolean createWorkingCopyInfo(IWorkingCopyBuffer buffer) {
        return this.getHandleManager().createWorkingCopyInfo(this, buffer);
    }

    private WorkingCopyInfo getWorkingCopyInfo() {
        return this.getHandleManager().getWorkingCopyInfo(this);
    }

    private WorkingCopyInfo peekAtWorkingCopyInfo() {
        return this.getHandleManager().peekAtWorkingCopyInfo(this);
    }

    private boolean discardWorkingCopyInfo() {
        return this.getHandleManager().discardWorkingCopyInfo(this);
    }

    private static class AstHolder {
        public final Object ast;
        public final NonExpiringSnapshot snapshot;

        public AstHolder(Object ast, NonExpiringSnapshot snapshot) {
            this.ast = ast;
            this.snapshot = snapshot;
        }
    }

    public class ReconcileOperation {
        protected ReconcileOperation() {
        }

        public void reconcile(Object ast, NonExpiringSnapshot snapshot, boolean forced) throws CoreException {
            if (!forced || SourceFile.this.shouldRebuildStructureIfForced()) {
                if (AST_HOLDER.get() != null) {
                    throw new AssertionError();
                }
                AST_HOLDER.set(new AstHolder(ast, snapshot));
                try {
                    SourceFile.this.openWhenClosed(SourceFile.this.newBody());
                }
                finally {
                    AST_HOLDER.set(null);
                }
            }
            if (WC_CREATION.get() == WcCreation.IN_PROGRESS) {
                SourceFile.this.workingCopyModeChanged();
                WC_CREATION.set(WcCreation.FINISHED);
            }
        }
    }

    private static enum WcCreation {
        IN_PROGRESS,
        FINISHED;

    }
}

