/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.SourceConstruct;

public class StructureHelper {
    private final Map<IHandle, Body> newElements;
    private final Map<Body, List<IHandle>> children = new HashMap<Body, List<IHandle>>();

    protected StructureHelper(Map<IHandle, Body> newElements) {
        if (newElements == null) {
            throw new IllegalArgumentException();
        }
        this.newElements = newElements;
    }

    protected void addChild(Body parentBody, IHandle handle, Body body) {
        if (parentBody == null) {
            throw new IllegalArgumentException();
        }
        if (handle == null) {
            throw new IllegalArgumentException();
        }
        if (body == null) {
            throw new IllegalArgumentException();
        }
        if (handle instanceof SourceConstruct) {
            this.resolveDuplicates((SourceConstruct)handle);
        }
        this.newElements.put(handle, body);
        List<IHandle> childrenList = this.children.get(parentBody);
        if (childrenList == null) {
            childrenList = new ArrayList<IHandle>();
            this.children.put(parentBody, childrenList);
        }
        childrenList.add(handle);
    }

    protected void complete(Body body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        List<IHandle> childrenList = this.children.remove(body);
        body.setChildren(childrenList == null ? Body.NO_CHILDREN : childrenList.toArray(new IHandle[childrenList.size()]));
    }

    protected static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private void resolveDuplicates(SourceConstruct element) {
        while (this.newElements.containsKey(element)) {
            element.incrementOccurenceCount();
        }
    }
}

