/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.Snapshot;

public final class TextFileSnapshot
extends Snapshot {
    private static final int DEFAULT_READING_SIZE = 8192;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private final IFile file;
    private final long modificationStamp;
    private Reference<String> contents;

    public TextFileSnapshot(IFile file) {
        this.file = file;
        this.modificationStamp = file.getModificationStamp();
    }

    @Override
    public synchronized String getContents() throws CoreException {
        String result = null;
        boolean sync = this.isSynchronized();
        if (this.contents != null) {
            if (!sync) {
                this.contents = null;
            } else {
                result = this.contents.get();
            }
        }
        if (result == null && sync) {
            String currentContents = this.readContents();
            if (this.isSynchronized()) {
                result = currentContents;
                this.contents = new SoftReference<String>(result);
            }
        }
        return result;
    }

    @Override
    protected Boolean predictEquality(Snapshot other) throws CoreException {
        if (!this.isSynchronized()) {
            return false;
        }
        if (other instanceof TextFileSnapshot) {
            if (!((TextFileSnapshot)other).isSynchronized()) {
                return false;
            }
            if (this.file.equals((Object)((TextFileSnapshot)other).file) && this.modificationStamp == ((TextFileSnapshot)other).modificationStamp) {
                return true;
            }
        }
        return null;
    }

    private boolean isSynchronized() {
        return this.modificationStamp == this.file.getModificationStamp();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readContents() throws CoreException {
        if (!this.file.exists()) {
            return "";
        }
        String encoding = null;
        try {
            encoding = this.file.getCharset();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            InputStream stream = this.file.getContents(false);
            try {
                String string;
                InputStreamReader reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
                try {
                    string = String.valueOf(TextFileSnapshot.getInputStreamAsCharArray(stream, reader));
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return string;
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    private static char[] getInputStreamAsCharArray(InputStream stream, InputStreamReader reader) throws IOException {
        char[] contents = EMPTY_CHAR_ARRAY;
        int contentsLength = 0;
        int amountRead = -1;
        do {
            int amountRequested;
            if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength + amountRequested];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
            if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
            contentsLength += amountRead;
        } while (amountRead != -1);
        int start = 0;
        if (contentsLength > 0 && "UTF-8".equals(reader.getEncoding()) && contents[0] == '\ufeff') {
            --contentsLength;
            start = 1;
        }
        if (contentsLength < contents.length) {
            char[] cArray = contents;
            contents = new char[contentsLength];
            System.arraycopy(cArray, start, contents, 0, contentsLength);
        }
        return contents;
    }
}

