/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.basic.ui.model.IFooElement;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModelManager;
import org.eclipse.handly.internal.examples.basic.ui.model.FooProject;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.HandleManager;

public class FooModel
extends Handle
implements IFooModel {
    private final IWorkspace workspace;

    public FooModel(IWorkspace workspace) {
        super(null, null);
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
    }

    @Override
    public IFooElement getParent() {
        return null;
    }

    @Override
    public IFooModel getRoot() {
        return this;
    }

    @Override
    public void addElementChangeListener(IElementChangeListener listener) {
        FooModelManager.INSTANCE.addElementChangeListener(listener);
    }

    @Override
    public void removeElementChangeListener(IElementChangeListener listener) {
        FooModelManager.INSTANCE.removeElementChangeListener(listener);
    }

    @Override
    public IFooProject getFooProject(String name) {
        return new FooProject(this, this.workspace.getRoot().getProject(name));
    }

    @Override
    public IFooProject[] getFooProjects() throws CoreException {
        IHandle[] children = this.getChildren();
        int length = children.length;
        IFooProject[] result = new IFooProject[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public IResource getResource() {
        return this.workspace.getRoot();
    }

    public boolean exists() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FooModel other = (FooModel)obj;
        return this.workspace.equals(other.workspace);
    }

    public int hashCode() {
        return this.workspace.hashCode();
    }

    protected void toStringName(StringBuilder builder) {
        builder.append("FooModel");
    }

    protected HandleManager getHandleManager() {
        return FooModelManager.INSTANCE.getHandleManager();
    }

    protected void validateExistence() {
    }

    protected void buildStructure(Body body, Map<IHandle, Body> newElements) throws CoreException {
        IProject[] projects = this.workspace.getRoot().getProjects();
        ArrayList<FooProject> fooProjects = new ArrayList<FooProject>(projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.hasNature("org.eclipse.handly.examples.basic.ui.fooNature")) {
                fooProjects.add(new FooProject(this, project));
            }
            ++n2;
        }
        body.setChildren(fooProjects.toArray(new IHandle[fooProjects.size()]));
    }
}

