/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.util.HashMap;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.ElementCache;
import org.eclipse.handly.model.impl.IBodyCache;

class FooModelCache
implements IBodyCache {
    private static final int DEFAULT_PROJECT_SIZE = 5;
    private static final int DEFAULT_FILE_SIZE = 100;
    private static final int DEFAULT_CHILDREN_SIZE = 2000;
    private final double memoryRatio = this.getMemoryRatio();
    private Body modelBody;
    private HashMap<IHandle, Body> projectCache = new HashMap(5);
    private ElementCache fileCache = new ElementCache((int)(100.0 * this.memoryRatio));
    private HashMap<IHandle, Body> childrenCache = new HashMap((int)(2000.0 * this.memoryRatio));

    public Body get(IHandle handle) {
        if (handle instanceof IFooModel) {
            return this.modelBody;
        }
        if (handle instanceof IFooProject) {
            return this.projectCache.get(handle);
        }
        if (handle instanceof IFooFile) {
            return (Body)this.fileCache.get((Object)handle);
        }
        return this.childrenCache.get(handle);
    }

    public Body peek(IHandle handle) {
        if (handle instanceof IFooModel) {
            return this.modelBody;
        }
        if (handle instanceof IFooProject) {
            return this.projectCache.get(handle);
        }
        if (handle instanceof IFooFile) {
            return (Body)this.fileCache.peek((Object)handle);
        }
        return this.childrenCache.get(handle);
    }

    public void put(IHandle handle, Body body) {
        if (handle instanceof IFooModel) {
            this.modelBody = body;
        } else if (handle instanceof IFooProject) {
            this.projectCache.put(handle, body);
            this.fileCache.ensureSpaceLimit(body, handle);
        } else if (handle instanceof IFooFile) {
            this.fileCache.put((Object)handle, (Object)body);
        } else {
            this.childrenCache.put(handle, body);
        }
    }

    public void remove(IHandle handle) {
        if (handle instanceof IFooModel) {
            this.modelBody = null;
        } else if (handle instanceof IFooProject) {
            this.projectCache.remove(handle);
            this.fileCache.resetSpaceLimit((int)(100.0 * this.getMemoryRatio()), handle);
        } else if (handle instanceof IFooFile) {
            this.fileCache.remove((Object)handle);
        } else {
            this.childrenCache.remove(handle);
        }
    }

    private double getMemoryRatio() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        return maxMemory == Long.MAX_VALUE ? 4.0 : (double)maxMemory / 6.7108864E7;
    }
}

