/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.outline;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.internal.examples.basic.ui.FooContentProvider;
import org.eclipse.handly.internal.examples.basic.ui.FooLabelProvider;
import org.eclipse.handly.internal.examples.basic.ui.SourceElementUtil;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.IHandleDelta;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.xtext.ui.editor.IXtextEditorAware;
import org.eclipse.xtext.ui.editor.XtextEditor;

public final class FooOutlinePage
extends ContentOutlinePage
implements IXtextEditorAware,
IElementChangeListener {
    private XtextEditor editor;
    private LinkingHelper linkingHelper;
    private IPropertyListener editorInputListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 258) {
                FooOutlinePage.this.getTreeViewer().setInput(FooOutlinePage.this.computeInput());
            }
        }
    };
    @Inject
    private FooContentProvider contentProvider;
    @Inject
    private FooLabelProvider labelProvider;

    public void setEditor(XtextEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)this.contentProvider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.getTreeViewer().setInput(this.computeInput());
        this.linkingHelper = new LinkingHelper();
        this.editor.addPropertyListener(this.editorInputListener);
        FooModelCore.getFooModel().addElementChangeListener(this);
    }

    public void dispose() {
        FooModelCore.getFooModel().removeElementChangeListener(this);
        this.editor.removePropertyListener(this.editorInputListener);
        if (this.linkingHelper != null) {
            this.linkingHelper.dispose();
        }
        this.editor.outlinePageClosed();
        super.dispose();
    }

    public void elementChanged(IElementChangeEvent event) {
        if (this.affects(event.getDelta(), (IHandle)this.getTreeViewer().getInput())) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Control control = FooOutlinePage.this.getTreeViewer().getControl();
                    if (control != null && !control.isDisposed()) {
                        FooOutlinePage.this.refresh();
                    }
                }
            });
        }
    }

    private boolean affects(IHandleDelta delta, IHandle element) {
        IHandleDelta[] children;
        if (delta.getElement().equals((Object)element)) {
            return true;
        }
        IHandleDelta[] iHandleDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IHandleDelta child = iHandleDeltaArray[n2];
            if (this.affects(child, element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Object computeInput() {
        IEditorInput editorInput = this.editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            return FooModelCore.create(file);
        }
        return null;
    }

    private void refresh() {
        Control control = this.getControl();
        control.setRedraw(false);
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                TreePath[] treePaths = FooOutlinePage.this.getTreeViewer().getExpandedTreePaths();
                FooOutlinePage.this.getTreeViewer().refresh();
                FooOutlinePage.this.getTreeViewer().setExpandedTreePaths(treePaths);
            }
        });
        control.setRedraw(true);
    }

    private class LinkingHelper
    extends OpenAndLinkWithEditorHelper {
        private LinkToOutlineJob linkToOutlineJob;
        private ISelectionChangedListener editorListener;

        public LinkingHelper() {
            super((StructuredViewer)FooOutlinePage.this.getTreeViewer());
            this.linkToOutlineJob = new LinkToOutlineJob();
            this.editorListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!FooOutlinePage.this.getTreeViewer().getControl().isFocusControl()) {
                        LinkingHelper.this.linkToOutline(event.getSelection());
                    }
                }
            };
            this.setLinkWithEditor(true);
            ISelectionProvider selectionProvider = FooOutlinePage.this.editor.getSite().getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.editorListener);
            } else {
                selectionProvider.addSelectionChangedListener(this.editorListener);
            }
        }

        public void dispose() {
            ISelectionProvider selectionProvider = FooOutlinePage.this.editor.getSite().getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.editorListener);
            } else {
                selectionProvider.removeSelectionChangedListener(this.editorListener);
            }
            this.cancelLinkToOutlineJob();
            super.dispose();
        }

        public void setLinkWithEditor(boolean enabled) {
            super.setLinkWithEditor(enabled);
            if (enabled) {
                this.linkToOutline(FooOutlinePage.this.editor.getSite().getSelectionProvider().getSelection());
            }
        }

        protected void activate(ISelection selection) {
            this.linkToEditor(selection);
        }

        protected void open(ISelection selection, boolean activate) {
            this.linkToEditor(selection);
        }

        protected void linkToEditor(ISelection selection) {
            this.cancelLinkToOutlineJob();
            if (selection == null || selection.isEmpty()) {
                return;
            }
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (!(element instanceof ISourceElement)) {
                return;
            }
            SourceElementUtil.revealInTextEditor((ITextEditor)FooOutlinePage.this.editor, (ISourceElement)element);
        }

        protected void linkToOutline(ISelection selection) {
            if (selection == null || selection.isEmpty()) {
                return;
            }
            if (selection instanceof ITextSelection) {
                this.scheduleLinkToOutlineJob((ITextSelection)selection);
            }
        }

        private void cancelLinkToOutlineJob() {
            this.linkToOutlineJob.cancel();
            this.linkToOutlineJob.setSelection(null);
        }

        private void scheduleLinkToOutlineJob(ITextSelection selection) {
            this.linkToOutlineJob.cancel();
            this.linkToOutlineJob.setSelection(selection);
            this.linkToOutlineJob.schedule();
        }

        private class LinkToOutlineJob
        extends Job {
            private volatile ITextSelection selection;

            public LinkToOutlineJob() {
                super("");
                this.setSystem(true);
            }

            public void setSelection(ITextSelection selection) {
                this.selection = selection;
            }

            protected IStatus run(IProgressMonitor monitor) {
                final ITextSelection baseSelection = this.selection;
                if (baseSelection == null || baseSelection.isEmpty()) {
                    return Status.OK_STATUS;
                }
                final TreeViewer treeViewer = FooOutlinePage.this.getTreeViewer();
                Object input = treeViewer.getInput();
                if (!(input instanceof ISourceElement)) {
                    return Status.OK_STATUS;
                }
                ISourceFile sourceFile = ((ISourceElement)input).getSourceFile();
                final ISourceElement element = SourceElementUtil.getSourceElement(sourceFile, baseSelection.getOffset());
                if (element == null) {
                    return Status.OK_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Control control = treeViewer.getControl();
                        Object input = treeViewer.getInput();
                        if (!(control != null && !control.isDisposed() && input instanceof ISourceElement && element.getSourceFile().equals((Object)((ISourceElement)input).getSourceFile()) && baseSelection.equals(LinkToOutlineJob.this.selection) && baseSelection.equals(FooOutlinePage.this.editor.getSelectionProvider().getSelection()))) {
                            return;
                        }
                        IStructuredSelection currentSelection = (IStructuredSelection)treeViewer.getSelection();
                        if (currentSelection == null || !currentSelection.toList().contains(element)) {
                            treeViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        }
    }
}

