/*******************************************************************************
 * Copyright (c) 2014 1C LLC.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Vladimir Piskarev (1C) - initial API and implementation
 *******************************************************************************/
package org.eclipse.handly.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator
    extends Plugin
{
    public static final String PLUGIN_ID = "org.eclipse.handly"; //$NON-NLS-1$

    private static Activator plugin;

    public Activator()
    {
        plugin = this;
    }

    public static Activator getDefault()
    {
        return plugin;
    }

    public static void log(IStatus status)
    {
        plugin.getLog().log(status);
    }

    public static IStatus createErrorStatus(String msg, Throwable e)
    {
        return new Status(IStatus.ERROR, PLUGIN_ID, 0, msg, e);
    }

    public static IStatus createWarningStatus(String msg)
    {
        return new Status(IStatus.WARNING, PLUGIN_ID, 0, msg, null);
    }

    @Override
    public void start(BundleContext context) throws Exception
    {
        super.start(context);
        Bundle b = Platform.getBundle("org.eclipse.ui"); //$NON-NLS-1$
        if (b != null && b.getState() == Bundle.ACTIVE
            && PlatformUI.isWorkbenchRunning())
        {
            UiSynchronizer.DEFAULT =
                new DisplaySynchronizer(PlatformUI.getWorkbench().getDisplay());
        }
    }

    @Override
    public void stop(BundleContext context) throws Exception
    {
        super.stop(context);
        UiSynchronizer.DEFAULT = null;
        plugin = null;
    }
}
