/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.xtext.ui.editor.HandlyXtextDocument;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.Messages;
import org.eclipse.xtext.ui.editor.SchedulingRuleFactory;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class HandlyDirtyStateEditorSupport
extends DirtyStateEditorSupport {
    public static final Object FAMILY_DIRTY_STATE_RECONCILER = new Object();
    protected static final ISchedulingRule SCHEDULING_RULE = SchedulingRuleFactory.INSTANCE.newSequence();
    private volatile DirtyStateEditorSupport.IDirtyStateEditorSupportClient currentClient;

    public void initializeDirtyStateSupport(DirtyStateEditorSupport.IDirtyStateEditorSupportClient client) {
        super.initializeDirtyStateSupport(client);
        IXtextDocument document = client.getDocument();
        if (document instanceof HandlyXtextDocument) {
            ((HandlyXtextDocument)document).setDirtyStateEditorSupport(this);
        }
        this.currentClient = client;
    }

    public void removeDirtyStateSupport(DirtyStateEditorSupport.IDirtyStateEditorSupportClient client) {
        super.removeDirtyStateSupport(client);
        IXtextDocument document = client.getDocument();
        if (document instanceof HandlyXtextDocument) {
            ((HandlyXtextDocument)document).setDirtyStateEditorSupport(null);
        }
        this.currentClient = null;
    }

    protected UpdateEditorStateJob createUpdateEditorJob() {
        return new UpdateEditorStateJob(SCHEDULING_RULE);
    }

    protected final DirtyStateEditorSupport.IDirtyStateEditorSupportClient getCurrentClient() {
        return this.currentClient;
    }

    protected class UpdateEditorStateJob
    extends DirtyStateEditorSupport.UpdateEditorStateJob {
        protected final AtomicInteger coarseGrainedChanges;
        protected final Queue<IResourceDescription.Delta> pendingChanges;

        public UpdateEditorStateJob(ISchedulingRule rule) {
            this(rule, Messages.DirtyStateEditorSupport_JobName);
        }

        public UpdateEditorStateJob(ISchedulingRule rule, String name) {
            super((DirtyStateEditorSupport)HandlyDirtyStateEditorSupport.this, rule, name);
            this.coarseGrainedChanges = new AtomicInteger();
            this.pendingChanges = new ConcurrentLinkedQueue<IResourceDescription.Delta>();
        }

        public void scheduleFor(IResourceDescription.Event event) {
            this.cancel();
            if (event instanceof IResourceDescription.CoarseGrainedEvent) {
                this.coarseGrainedChanges.incrementAndGet();
            } else {
                this.pendingChanges.addAll((Collection<IResourceDescription.Delta>)event.getDeltas());
            }
            this.schedule(this.getDelay());
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_DIRTY_STATE_RECONCILER;
        }

        protected IStatus run(final IProgressMonitor monitor) {
            try {
                DirtyStateEditorSupport.IDirtyStateEditorSupportClient myClient = HandlyDirtyStateEditorSupport.this.currentClient;
                if (myClient == null) {
                    return Status.OK_STATUS;
                }
                HandlyXtextDocument document = (HandlyXtextDocument)myClient.getDocument();
                if (document == null) {
                    return Status.OK_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int coarseGrainedChangesSeen = this.coarseGrainedChanges.get();
                final boolean[] isReparseRequired = new boolean[]{coarseGrainedChangesSeen > 0};
                final Pair<IResourceDescription.Event, Integer> event = this.mergePendingDeltas();
                Collection affectedResources = (Collection)document.readOnly((IUnitOfWork)new IUnitOfWork<Collection<Resource>, XtextResource>(){

                    public Collection<Resource> exec(XtextResource resource) throws Exception {
                        if (resource == null || resource.getResourceSet() == null) {
                            return null;
                        }
                        Collection affectedResources = HandlyDirtyStateEditorSupport.this.collectAffectedResources(resource, (IResourceDescription.Event)event.getFirst());
                        if (monitor.isCanceled() || !affectedResources.isEmpty()) {
                            return affectedResources;
                        }
                        if (!isReparseRequired[0]) {
                            isReparseRequired[0] = HandlyDirtyStateEditorSupport.this.isReparseRequired(resource, (IResourceDescription.Event)event.getFirst());
                        }
                        return affectedResources;
                    }
                });
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.unloadAffectedResourcesAndReparseDocument(document, affectedResources, isReparseRequired[0]);
                int i = 0;
                while (i < (Integer)event.getSecond()) {
                    this.pendingChanges.poll();
                    ++i;
                }
                this.coarseGrainedChanges.addAndGet(-coarseGrainedChangesSeen);
            }
            catch (Throwable e) {
                Activator.log(Activator.createErrorStatus("Error updating editor state", e));
            }
            return Status.OK_STATUS;
        }

        protected Pair<IResourceDescription.Event, Integer> mergePendingDeltas() {
            LinkedHashMap uriToDelta = Maps.newLinkedHashMap();
            Iterator iter = this.pendingChanges.iterator();
            int size = 0;
            while (iter.hasNext()) {
                IResourceDescription.Delta delta = (IResourceDescription.Delta)iter.next();
                URI uri = delta.getUri();
                IResourceDescription.Delta prev = (IResourceDescription.Delta)uriToDelta.get(uri);
                if (prev == null) {
                    uriToDelta.put(uri, delta);
                } else if (prev.getOld() != delta.getNew()) {
                    uriToDelta.put(uri, HandlyDirtyStateEditorSupport.this.createDelta(delta, prev));
                } else {
                    uriToDelta.remove(uri);
                }
                ++size;
            }
            ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(uriToDelta.values());
            return Tuples.create((Object)event, (Object)size);
        }

        private void unloadAffectedResourcesAndReparseDocument(final HandlyXtextDocument document, final Collection<Resource> affectedResources, boolean reparseRequired) {
            if ((affectedResources == null || affectedResources.isEmpty()) && !reparseRequired) {
                return;
            }
            document.internalModify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource resource) throws Exception {
                    if (resource == null || resource.getResourceSet() == null) {
                        return;
                    }
                    ResourceSet resourceSet = resource.getResourceSet();
                    if (affectedResources != null) {
                        for (Resource affectedResource : affectedResources) {
                            affectedResource.unload();
                            resourceSet.getResources().remove((Object)affectedResource);
                        }
                    }
                    document.reconcile(true);
                }
            });
        }
    }
}

