/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.handly.document.DocumentChange;
import org.eclipse.handly.document.DocumentChangeOperation;
import org.eclipse.handly.document.IDocumentChange;
import org.eclipse.handly.document.UiDocumentChangeRunner;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.ISnapshotProvider;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.handly.xtext.ui.editor.IHandlyXtextDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IBatchLinkableResource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.IXtextModelListenerExtension;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.ui.editor.reconciler.CancelIndicatorBasedProgressMonitor;
import org.eclipse.xtext.ui.editor.reconciler.ReplaceRegion;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class HandlyXtextDocument
extends XtextDocument
implements IHandlyXtextDocument {
    private static final IUnitOfWork.Void<XtextResource> NO_OP = new IUnitOfWork.Void<XtextResource>(){

        public void process(XtextResource resource) {
        }
    };
    private final BooleanThreadLocal hasTopLevelModification = new BooleanThreadLocal();
    private ITextEditComposer composer2;
    private final List<IXtextModelListener> modelListeners2 = new ArrayList<IXtextModelListener>();
    private volatile NonExpiringSnapshot reconciledSnapshot;
    private final ListenerList reconcilingListeners = new ListenerList(1);
    private final DocumentListener selfListener = new DocumentListener();
    private PendingChange pendingChange;
    private final Object pendingChangeLock = new Object();
    private DirtyStateEditorSupport dirtyStateEditorSupport;

    @Inject
    public HandlyXtextDocument(DocumentTokenSource tokenSource, ITextEditComposer composer) {
        super(tokenSource, composer);
        this.composer2 = composer;
    }

    public void setInput(XtextResource resource) {
        super.setInput(resource);
        this.reconciledSnapshot = this.getNonExpiringSnapshot();
        this.addDocumentListener(this.selfListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeInput() {
        this.removeDocumentListener(this.selfListener);
        this.getAndResetPendingChange();
        this.reconciledSnapshot = null;
        this.reconcilingListeners.clear();
        List<IXtextModelListener> list = this.modelListeners2;
        synchronized (list) {
            this.modelListeners2.clear();
        }
        Job validationJob = this.getValidationJob();
        if (validationJob != null) {
            validationJob.cancel();
        }
        this.setValidationJob(null);
        this.detachResource();
    }

    public ISnapshot getSnapshot() {
        return new DocumentSnapshot((IDocument)this);
    }

    @Override
    public ISnapshot getReconciledSnapshot() {
        return this.reconciledSnapshot.getWrappedSnapshot();
    }

    public void addReconcilingListener(IReconcilingListener listener) {
        this.reconcilingListeners.add((Object)listener);
    }

    public void removeReconcilingListener(IReconcilingListener listener) {
        this.reconcilingListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(IXtextModelListener listener) {
        Assert.isNotNull((Object)listener);
        List<IXtextModelListener> list = this.modelListeners2;
        synchronized (list) {
            if (this.modelListeners2.contains(listener)) {
                return;
            }
            if (listener instanceof DirtyStateEditorSupport) {
                this.modelListeners2.add(0, listener);
            } else {
                this.modelListeners2.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(IXtextModelListener listener) {
        Assert.isNotNull((Object)listener);
        List<IXtextModelListener> list = this.modelListeners2;
        synchronized (list) {
            this.modelListeners2.remove(listener);
        }
    }

    @Override
    public boolean needsReconciling() {
        return !this.getSnapshot().isEqualTo(this.getReconciledSnapshot());
    }

    @Override
    public boolean reconcile(boolean force) {
        if (!force) {
            this.readOnly((IUnitOfWork)NO_OP);
        } else {
            T2MReconcilingUnitOfWork reconcilingUnitOfWork = new T2MReconcilingUnitOfWork(true);
            this.internalModify(reconcilingUnitOfWork);
        }
        return true;
    }

    public boolean reconcile(IXtextDocumentContentObserver.Processor processor) {
        T2MReconcilingUnitOfWork reconcilingUnitOfWork = new T2MReconcilingUnitOfWork(false);
        return (Boolean)processor.process((IUnitOfWork)reconcilingUnitOfWork);
    }

    @Override
    public <T> T modify(IUnitOfWork<T, XtextResource> work) {
        if (!((Boolean)this.hasTopLevelModification.get()).booleanValue()) {
            work = new M2TReconcilingUnitOfWork<T>(work);
        }
        return (T)this.internalModify(work);
    }

    @Override
    public IDocumentChange applyChange(IDocumentChange change) throws BadLocationException {
        DocumentChangeOperation operation = new DocumentChangeOperation((IDocument)this, change);
        UiDocumentChangeRunner runner = new UiDocumentChangeRunner(UiSynchronizer.DEFAULT, operation);
        return runner.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyModelListeners(XtextResource resource) {
        ArrayList<IXtextModelListener> modelListenersCopy;
        List<IXtextModelListener> list = this.modelListeners2;
        synchronized (list) {
            modelListenersCopy = new ArrayList<IXtextModelListener>(this.modelListeners2);
        }
        for (IXtextModelListener listener : modelListenersCopy) {
            try {
                if (this.isOutdated()) {
                    return;
                }
                if (listener instanceof IXtextModelListenerExtension) {
                    ((IXtextModelListenerExtension)listener).modelChanged(resource, new CancelIndicator(){

                        public boolean isCanceled() {
                            return HandlyXtextDocument.this.isOutdated();
                        }
                    });
                    continue;
                }
                listener.modelChanged(resource);
            }
            catch (Exception e) {
                Activator.log(Activator.createErrorStatus("Error in IXtextModelListener", e));
            }
        }
    }

    void setDirtyStateEditorSupport(DirtyStateEditorSupport dirtyStateEditorSupport) {
        this.dirtyStateEditorSupport = dirtyStateEditorSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingChange getAndResetPendingChange() {
        PendingChange result;
        Object object = this.pendingChangeLock;
        synchronized (object) {
            result = this.pendingChange;
            this.pendingChange = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocumentChanged(DocumentEvent event) {
        Object object = this.pendingChangeLock;
        synchronized (object) {
            if (this.pendingChange == null) {
                this.pendingChange = new PendingChange();
            }
            this.pendingChange.add(event);
        }
    }

    private NonExpiringSnapshot getNonExpiringSnapshot() {
        return new NonExpiringSnapshot((ISnapshotProvider)this);
    }

    private void reconciled(final XtextResource resource, final NonExpiringSnapshot snapshot, final boolean forced) {
        Object[] listeners;
        this.postProcess(resource, (IProgressMonitor)new CancelIndicatorBasedProgressMonitor(HandlyXtextDocument.getOutdatedStateCancelIndicator((XtextResource)resource)));
        Object[] objectArray = listeners = this.reconcilingListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IReconcilingListener)listener).reconciled(resource, snapshot, forced);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++n2;
        }
        this.reconciledSnapshot = snapshot;
    }

    private void postProcess(XtextResource resource, final IProgressMonitor monitor) {
        if (this.dirtyStateEditorSupport != null) {
            this.dirtyStateEditorSupport.announceDirtyState(resource);
        }
        CancelIndicator cancelIndicator = new CancelIndicator(){

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        };
        try {
            if (resource instanceof DerivedStateAwareResource) {
                ((DerivedStateAwareResource)resource).installDerivedState(false);
            }
            if (resource instanceof IBatchLinkableResource) {
                ((IBatchLinkableResource)resource).linkBatched(cancelIndicator);
            }
        }
        catch (OperationCanceledException e) {
            resource.getCache().clear((Resource)resource);
        }
        catch (RuntimeException e) {
            Activator.log(Activator.createErrorStatus("Error post-processing resource", e));
        }
    }

    private void internalReconcile(XtextResource resource) {
        this.reconcile(new InternalProcessor(resource));
    }

    private void detachResource() {
        this.internalModify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource resource) throws Exception {
                HandlyXtextDocument.clearInternalState(resource);
                resource.getResourceSet().getResources().clear();
            }
        });
    }

    private static void clearInternalState(XtextResource resource) throws Exception {
        Field isUpdating = XtextResource.class.getDeclaredField("isUpdating");
        isUpdating.setAccessible(true);
        Method clearInternalState = XtextResource.class.getDeclaredMethod("clearInternalState", new Class[0]);
        clearInternalState.setAccessible(true);
        try {
            isUpdating.set(resource, true);
            clearInternalState.invoke((Object)resource, new Object[0]);
        }
        finally {
            isUpdating.set(resource, false);
        }
    }

    private static class BooleanThreadLocal
    extends ThreadLocal<Boolean> {
        private BooleanThreadLocal() {
        }

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            HandlyXtextDocument.this.handleDocumentChanged(event);
        }
    }

    public static interface IReconcilingListener {
        public void reconciled(XtextResource var1, NonExpiringSnapshot var2, boolean var3);
    }

    private static class InternalProcessor
    implements IXtextDocumentContentObserver.Processor {
        private final XtextResource resource;

        public InternalProcessor(XtextResource resource) {
            this.resource = resource;
        }

        public <T> T process(IUnitOfWork<T, XtextResource> transaction) {
            try {
                return (T)transaction.exec((Object)this.resource);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
    }

    private class M2TReconcilingUnitOfWork<T>
    implements IUnitOfWork<T, XtextResource> {
        private final IUnitOfWork<T, XtextResource> work;
        private ISnapshot baseSnapshot;

        public M2TReconcilingUnitOfWork(IUnitOfWork<T, XtextResource> work) {
            this.work = work;
        }

        public T exec(XtextResource resource) throws Exception {
            HandlyXtextDocument.this.hasTopLevelModification.set(true);
            try {
                Object result;
                HandlyXtextDocument.this.internalReconcile(resource);
                this.baseSnapshot = HandlyXtextDocument.this.getReconciledSnapshot();
                try {
                    EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
                    HandlyXtextDocument.this.composer2.beginRecording((Resource)resource);
                    result = this.work.exec((Object)resource);
                    TextEdit edit = HandlyXtextDocument.this.composer2.endRecording();
                    if (edit != null) {
                        DocumentChange change = new DocumentChange(edit);
                        change.setBase(this.baseSnapshot);
                        if (this.work instanceof IHandlyXtextDocument.IUndoableUnitOfWork) {
                            change.setStyle(1);
                        } else {
                            change.setStyle(0);
                        }
                        IDocumentChange undoChange = HandlyXtextDocument.this.applyChange((IDocumentChange)change);
                        if (this.work instanceof IHandlyXtextDocument.IUndoableUnitOfWork) {
                            ((IHandlyXtextDocument.IUndoableUnitOfWork)this.work).acceptUndoChange(undoChange);
                        }
                    }
                }
                catch (Exception e) {
                    Activator.log(Activator.createErrorStatus(e.getMessage(), e));
                    resource.reparse(HandlyXtextDocument.this.reconciledSnapshot.getContents());
                    throw e;
                }
                HandlyXtextDocument.this.internalReconcile(resource);
                Object object = result;
                return (T)object;
            }
            finally {
                HandlyXtextDocument.this.hasTopLevelModification.remove();
            }
        }
    }

    private class PendingChange {
        private NonExpiringSnapshot snapshotToReconcile;
        private ReplaceRegion replaceRegionToReconcile;
        private long modificationStamp;

        private PendingChange() {
        }

        public NonExpiringSnapshot getSnapshotToReconcile() {
            return this.snapshotToReconcile;
        }

        public ReplaceRegion getReplaceRegionToReconcile() {
            return this.replaceRegionToReconcile;
        }

        public long getModificationStamp() {
            return this.modificationStamp;
        }

        public void add(DocumentEvent event) {
            this.snapshotToReconcile = HandlyXtextDocument.this.getNonExpiringSnapshot();
            ReplaceRegion replaceRegion = new ReplaceRegion(event.getOffset(), event.getLength(), event.getText());
            if (this.replaceRegionToReconcile == null) {
                this.replaceRegionToReconcile = replaceRegion;
            } else {
                this.replaceRegionToReconcile.mergeWith(replaceRegion, (Object)this.snapshotToReconcile.getContents());
            }
            this.modificationStamp = event.getModificationStamp();
        }
    }

    private class T2MReconcilingUnitOfWork
    implements IUnitOfWork<Boolean, XtextResource> {
        private final boolean force;

        public T2MReconcilingUnitOfWork(boolean force) {
            this.force = force;
        }

        public Boolean exec(XtextResource resource) throws Exception {
            PendingChange change = HandlyXtextDocument.this.getAndResetPendingChange();
            if (change == null) {
                if (this.force) {
                    NonExpiringSnapshot snapshot = HandlyXtextDocument.this.reconciledSnapshot;
                    resource.update(0, 0, "");
                    HandlyXtextDocument.this.reconciled(resource, snapshot, true);
                }
                return false;
            }
            NonExpiringSnapshot snapshot = change.getSnapshotToReconcile();
            ReplaceRegion replaceRegion = change.getReplaceRegionToReconcile();
            long modificationStamp = change.getModificationStamp();
            try {
                resource.update(replaceRegion.getOffset(), replaceRegion.getLength(), replaceRegion.getText());
                resource.setModificationStamp(modificationStamp);
            }
            catch (Exception e) {
                Activator.log(Activator.createErrorStatus(e.getMessage(), e));
                try {
                    resource.reparse(snapshot.getContents());
                    resource.setModificationStamp(modificationStamp);
                }
                catch (Exception e2) {
                    Activator.log(Activator.createErrorStatus(e2.getMessage(), e2));
                    resource.reparse(HandlyXtextDocument.this.reconciledSnapshot.getContents());
                    throw e2;
                }
            }
            HandlyXtextDocument.this.reconciled(resource, snapshot, false);
            return true;
        }
    }
}

