/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.HandleDelta;

public class Body {
    public static IHandle[] NO_CHILDREN = new IHandle[0];
    private volatile IHandle[] children = NO_CHILDREN;

    public IHandle[] getChildren() {
        return this.children;
    }

    public void setChildren(IHandle[] children) {
        this.children = children;
    }

    public void addChild(IHandle child) {
        IHandle[] oldChildren = this.children;
        int length = oldChildren.length;
        if (length == 0) {
            this.children = new IHandle[]{child};
        } else {
            int i = 0;
            while (i < length) {
                if (oldChildren[i].equals(child)) {
                    return;
                }
                ++i;
            }
            IHandle[] newChildren = new IHandle[length + 1];
            System.arraycopy(oldChildren, 0, newChildren, 0, length);
            newChildren[length] = child;
            this.children = newChildren;
        }
    }

    public void removeChild(IHandle child) {
        IHandle[] oldChildren = this.children;
        int i = 0;
        int length = oldChildren.length;
        while (i < length) {
            if (oldChildren[i].equals(child)) {
                if (length == 1) {
                    this.children = NO_CHILDREN;
                    break;
                }
                IHandle[] newChildren = new IHandle[length - 1];
                System.arraycopy(oldChildren, 0, newChildren, 0, i);
                if (i < length - 1) {
                    System.arraycopy(oldChildren, i + 1, newChildren, i, length - i - 1);
                }
                this.children = newChildren;
                break;
            }
            ++i;
        }
    }

    public void findContentChange(Body oldBody, IHandle element, HandleDelta delta) {
    }
}

