/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.IHandleDelta;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.Handle;

public class HandleDelta
implements IHandleDelta {
    private static final IHandleDelta[] EMPTY_HANDLE_DELTAS = new IHandleDelta[0];
    private static final IMarkerDelta[] EMPTY_MARKER_DELTAS = new IMarkerDelta[0];
    private static final IResourceDelta[] EMPTY_RESOURCE_DELTAS = new IResourceDelta[0];
    private static int NEED_CHILD_INDEX = 3;
    protected int kind;
    protected int flags;
    protected final IHandle element;
    protected IHandle movedFromElement;
    protected IHandle movedToElement;
    protected IHandleDelta[] affectedChildren = EMPTY_HANDLE_DELTAS;
    protected Map<Key, Integer> childIndex;
    protected IMarkerDelta[] markerDeltas;
    protected IResourceDelta[] resourceDeltas;
    protected int resourceDeltasCounter;

    public HandleDelta(IHandle element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
    }

    @Override
    public final IHandle getElement() {
        return this.element;
    }

    @Override
    public final int getKind() {
        return this.kind;
    }

    @Override
    public final int getFlags() {
        return this.flags;
    }

    @Override
    public final IHandleDelta[] getAffectedChildren() {
        return this.affectedChildren;
    }

    @Override
    public final IHandleDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    @Override
    public final IHandleDelta[] getRemovedChildren() {
        return this.getChildrenOfType(2);
    }

    @Override
    public final IHandleDelta[] getChangedChildren() {
        return this.getChildrenOfType(3);
    }

    @Override
    public final IHandle getMovedFromElement() {
        return this.movedFromElement;
    }

    @Override
    public final IHandle getMovedToElement() {
        return this.movedToElement;
    }

    @Override
    public IMarkerDelta[] getMarkerDeltas() {
        if (this.markerDeltas == null) {
            return EMPTY_MARKER_DELTAS;
        }
        return this.markerDeltas;
    }

    @Override
    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return EMPTY_RESOURCE_DELTAS;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    public boolean isEmpty() {
        return this.kind == 0;
    }

    public final HandleDelta insertAdded(IHandle element) {
        return this.insertAdded(element, 0);
    }

    public HandleDelta insertAdded(IHandle element, int flags) {
        this.insert(this.newAdded(element, flags));
        return this;
    }

    public final HandleDelta insertRemoved(IHandle element) {
        return this.insertRemoved(element, 0);
    }

    public HandleDelta insertRemoved(IHandle element, int flags) {
        HandleDelta delta = this.newDelta(element);
        delta.flags = flags;
        this.insert(delta);
        HandleDelta actualDelta = this.getDeltaFor(element);
        if (actualDelta != null) {
            actualDelta.kind = 2;
            actualDelta.flags = flags;
            actualDelta.clearAffectedChildren();
        }
        return this;
    }

    public HandleDelta insertChanged(IHandle element, int flags) {
        this.insert(this.newChanged(element, flags));
        return this;
    }

    public HandleDelta insertMovedFrom(IHandle movedFromElement, IHandle movedToElement) {
        this.insert(this.newMovedFrom(movedFromElement, movedToElement));
        return this;
    }

    public HandleDelta insertMovedTo(IHandle movedToElement, IHandle movedFromElement) {
        this.insert(this.newMovedTo(movedToElement, movedFromElement));
        return this;
    }

    public void insert(HandleDelta delta) {
        HandleDelta childDelta = this.createDeltaTree(delta);
        if (!HandleDelta.equalsAndSameParent(delta.getElement(), this.getElement())) {
            this.addAffectedChild(childDelta);
        }
    }

    public HandleDelta createDeltaTree(HandleDelta delta) {
        if (delta == null) {
            throw new IllegalArgumentException();
        }
        HandleDelta childDelta = delta;
        List<IHandle> ancestors = this.getAncestors(delta.getElement());
        if (ancestors == null) {
            if (HandleDelta.equalsAndSameParent(delta.getElement(), this.getElement())) {
                this.kind = delta.kind;
                this.flags = delta.flags;
                this.movedToElement = delta.movedToElement;
                this.movedFromElement = delta.movedFromElement;
            }
        } else {
            int i = 0;
            int size = ancestors.size();
            while (i < size) {
                IHandle ancestor = ancestors.get(i);
                HandleDelta ancestorDelta = this.newDelta(ancestor);
                ancestorDelta.addAffectedChild(childDelta);
                childDelta = ancestorDelta;
                ++i;
            }
        }
        return childDelta;
    }

    public void addAffectedChild(HandleDelta child) {
        Key childKey;
        Integer existingChildIndex;
        if (child == null) {
            throw new IllegalArgumentException();
        }
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                this.flags |= 2;
                break;
            }
            default: {
                this.kind = 3;
                this.flags |= 2;
            }
        }
        if (this.element instanceof ISourceFile) {
            this.flags |= 0x20;
        }
        if ((existingChildIndex = this.getChildIndex(childKey = new Key(child.getElement()))) == null) {
            this.addNewChild(child);
        } else {
            HandleDelta existingChild = (HandleDelta)this.affectedChildren[existingChildIndex];
            switch (existingChild.getKind()) {
                case 1: {
                    switch (child.getKind()) {
                        case 1: 
                        case 3: {
                            return;
                        }
                        case 2: {
                            this.removeExistingChild(childKey, existingChildIndex);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (child.getKind()) {
                        case 1: {
                            child.kind = 3;
                            this.affectedChildren[existingChildIndex.intValue()] = child;
                            return;
                        }
                        case 2: 
                        case 3: {
                            return;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (child.getKind()) {
                        case 1: 
                        case 2: {
                            this.affectedChildren[existingChildIndex.intValue()] = child;
                            return;
                        }
                        case 3: {
                            IHandleDelta[] children = child.getAffectedChildren();
                            int i = 0;
                            while (i < children.length) {
                                HandleDelta childsChild = (HandleDelta)children[i];
                                existingChild.addAffectedChild(childsChild);
                                ++i;
                            }
                            boolean childHadContentFlag = (child.flags & 1) != 0;
                            boolean existingChildHadChildrenFlag = (existingChild.flags & 2) != 0;
                            existingChild.flags |= child.flags;
                            if (childHadContentFlag && existingChildHadChildrenFlag) {
                                existingChild.flags &= 0xFFFFFFFE;
                            }
                            if (child.markerDeltas != null) {
                                if (existingChild.markerDeltas != null) {
                                    throw new AssertionError((Object)"Merge of marker deltas is not supported");
                                }
                                existingChild.markerDeltas = child.markerDeltas;
                            }
                            if (child.resourceDeltas != null) {
                                if (existingChild.resourceDeltas != null) {
                                    throw new AssertionError((Object)"Merge of resource deltas is not supported");
                                }
                                existingChild.resourceDeltas = child.resourceDeltas;
                                existingChild.resourceDeltasCounter = child.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    int flags = existingChild.getFlags();
                    this.affectedChildren[existingChildIndex.intValue()] = child;
                    child.flags |= flags;
                }
            }
        }
    }

    public void removeAffectedChild(HandleDelta child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        if (this.affectedChildren.length == 0) {
            return;
        }
        Key childKey = new Key(child.getElement());
        Integer exisingChildIndex = this.getChildIndex(childKey);
        if (exisingChildIndex != null) {
            this.removeExistingChild(childKey, exisingChildIndex);
        }
    }

    public void clearAffectedChildren() {
        this.affectedChildren = EMPTY_HANDLE_DELTAS;
        this.childIndex = null;
    }

    public HandleDelta getDeltaFor(IHandle element) {
        if (element == null) {
            return null;
        }
        if (HandleDelta.equalsAndSameParent(this.getElement(), element)) {
            return this;
        }
        return this.findDescendant(new Key(element));
    }

    public void setMarkerDeltas(IMarkerDelta[] markerDeltas) {
        if (markerDeltas == null || markerDeltas.length == 0) {
            throw new IllegalArgumentException();
        }
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                this.flags |= 0x400;
                break;
            }
            default: {
                this.kind = 3;
                this.flags |= 0x400;
            }
        }
        this.markerDeltas = markerDeltas;
    }

    public void addResourceDelta(IResourceDelta child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                this.flags |= 1;
                break;
            }
            default: {
                this.kind = 3;
                this.flags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = child;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = child;
    }

    public String toString() {
        return this.toDebugString(0);
    }

    public String toDebugString(int depth) {
        int i;
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < depth) {
            buffer.append('\t');
            ++i2;
        }
        buffer.append(((Handle)this.getElement()).toDebugString());
        this.toDebugString(buffer);
        IHandleDelta[] children = this.getAffectedChildren();
        if (children != null) {
            i = 0;
            while (i < children.length) {
                buffer.append("\n");
                buffer.append(((HandleDelta)children[i]).toDebugString(depth + 1));
                ++i;
            }
        }
        i = 0;
        while (i < this.resourceDeltasCounter) {
            buffer.append("\n");
            int j = 0;
            while (j < depth + 1) {
                buffer.append('\t');
                ++j;
            }
            IResourceDelta resourceDelta = this.resourceDeltas[i];
            buffer.append(resourceDelta.toString());
            buffer.append("[");
            switch (resourceDelta.getKind()) {
                case 1: {
                    buffer.append('+');
                    break;
                }
                case 2: {
                    buffer.append('-');
                    break;
                }
                case 4: {
                    buffer.append('*');
                    break;
                }
                default: {
                    buffer.append('?');
                }
            }
            buffer.append("]");
            ++i;
        }
        return buffer.toString();
    }

    protected void toDebugString(StringBuffer buffer) {
        buffer.append("[");
        switch (this.getKind()) {
            case 1: {
                buffer.append('+');
                break;
            }
            case 2: {
                buffer.append('-');
                break;
            }
            case 3: {
                buffer.append('*');
                break;
            }
            default: {
                buffer.append('?');
            }
        }
        buffer.append("]: {");
        this.toDebugString(buffer, this.getFlags());
        buffer.append("}");
    }

    protected boolean toDebugString(StringBuffer buffer, int flags) {
        boolean prev = false;
        if ((flags & 1) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CONTENT");
            prev = true;
        }
        if ((flags & 2) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CHILDREN");
            prev = true;
        }
        if ((flags & 4) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_FROM(" + ((Handle)this.getMovedFromElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((flags & 8) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_TO(" + ((Handle)this.getMovedToElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((flags & 0x10) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REORDERED");
            prev = true;
        }
        if ((flags & 0x20) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("FINE GRAINED");
            prev = true;
        }
        if ((flags & 0x40) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("OPEN");
            prev = true;
        }
        if ((flags & 0x80) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("DESCRIPTION");
            prev = true;
        }
        if ((flags & 0x100) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("WORKING COPY");
            prev = true;
        }
        if ((flags & 0x200) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("UNDERLYING_RESOURCE");
            prev = true;
        }
        if ((flags & 0x400) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MARKERS");
            prev = true;
        }
        if ((flags & 0x800) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("SYNC");
            prev = true;
        }
        return prev;
    }

    protected HandleDelta newDelta(IHandle element) {
        return new HandleDelta(element);
    }

    protected HandleDelta newAdded(IHandle element, int flags) {
        HandleDelta delta = this.newDelta(element);
        delta.kind = 1;
        delta.flags = flags;
        return delta;
    }

    protected HandleDelta newRemoved(IHandle element, int flags) {
        HandleDelta delta = this.newDelta(element);
        delta.kind = 2;
        delta.flags = flags;
        return delta;
    }

    protected HandleDelta newChanged(IHandle element, int flags) {
        HandleDelta delta = this.newDelta(element);
        delta.kind = 3;
        delta.flags = flags;
        return delta;
    }

    protected HandleDelta newMovedFrom(IHandle movedFromElement, IHandle movedToElement) {
        HandleDelta delta = this.newRemoved(movedFromElement, 8);
        if (movedToElement == null) {
            throw new IllegalArgumentException();
        }
        delta.movedToElement = movedToElement;
        return delta;
    }

    protected HandleDelta newMovedTo(IHandle movedToElement, IHandle movedFromElement) {
        HandleDelta delta = this.newAdded(movedToElement, 4);
        if (movedFromElement == null) {
            throw new IllegalArgumentException();
        }
        delta.movedFromElement = movedFromElement;
        return delta;
    }

    protected final List<IHandle> getAncestors(IHandle child) {
        IHandle parent = child.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<IHandle> parents = new ArrayList<IHandle>();
        while (!parent.equals(this.getElement())) {
            parents.add(parent);
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        parents.trimToSize();
        return parents;
    }

    protected final IHandleDelta[] getChildrenOfType(int type) {
        int length = this.affectedChildren.length;
        if (length == 0) {
            return EMPTY_HANDLE_DELTAS;
        }
        ArrayList<IHandleDelta> children = new ArrayList<IHandleDelta>(length);
        int i = 0;
        while (i < length) {
            if (this.affectedChildren[i].getKind() == type) {
                children.add(this.affectedChildren[i]);
            }
            ++i;
        }
        IHandleDelta[] childrenOfType = new IHandleDelta[children.size()];
        children.toArray(childrenOfType);
        return childrenOfType;
    }

    protected final HandleDelta findDescendant(Key key) {
        if (this.affectedChildren.length == 0) {
            return null;
        }
        Integer index = this.getChildIndex(key);
        if (index != null) {
            return (HandleDelta)this.affectedChildren[index];
        }
        IHandleDelta[] iHandleDeltaArray = this.affectedChildren;
        int n = this.affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IHandleDelta child = iHandleDeltaArray[n2];
            HandleDelta delta = ((HandleDelta)child).findDescendant(key);
            if (delta != null) {
                return delta;
            }
            ++n2;
        }
        return null;
    }

    protected Integer getChildIndex(Key key) {
        int length = this.affectedChildren.length;
        if (length < NEED_CHILD_INDEX) {
            int i = 0;
            while (i < length) {
                if (HandleDelta.equalsAndSameParent(key.getElement(), this.affectedChildren[i].getElement())) {
                    return i;
                }
                ++i;
            }
            return null;
        }
        if (this.childIndex == null) {
            this.childIndex = new HashMap<Key, Integer>();
            int i = 0;
            while (i < length) {
                this.childIndex.put(new Key(this.affectedChildren[i].getElement()), i);
                ++i;
            }
        }
        return this.childIndex.get(key);
    }

    protected void addNewChild(HandleDelta child) {
        this.affectedChildren = HandleDelta.growAndAddToArray(this.affectedChildren, child);
        if (this.childIndex != null) {
            this.childIndex.put(new Key(child.getElement()), this.affectedChildren.length - 1);
        }
    }

    protected void removeExistingChild(Key key, int index) {
        this.affectedChildren = HandleDelta.removeAndShrinkArray(this.affectedChildren, index);
        if (this.childIndex != null) {
            int length = this.affectedChildren.length;
            if (length < NEED_CHILD_INDEX) {
                this.childIndex = null;
            } else {
                this.childIndex.remove(key);
                int i = index;
                while (i < length) {
                    this.childIndex.put(new Key(this.affectedChildren[i].getElement()), i);
                    ++i;
                }
            }
        }
    }

    protected static boolean equalsAndSameParent(IHandle e1, IHandle e2) {
        if (!e1.equals(e2)) {
            return false;
        }
        IHandle parent1 = e1.getParent();
        IHandle parent2 = e2.getParent();
        return !(parent1 == null ? parent2 != null : !parent1.equals(parent2));
    }

    protected static IHandleDelta[] growAndAddToArray(IHandleDelta[] array, IHandleDelta addition) {
        IHandleDelta[] old = array;
        array = new IHandleDelta[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected static IHandleDelta[] removeAndShrinkArray(IHandleDelta[] old, int index) {
        int rest;
        IHandleDelta[] array = new IHandleDelta[old.length - 1];
        if (index > 0) {
            System.arraycopy(old, 0, array, 0, index);
        }
        if ((rest = old.length - index - 1) > 0) {
            System.arraycopy(old, index + 1, array, index, rest);
        }
        return array;
    }

    protected static class Key {
        private final IHandle element;

        public Key(IHandle element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            this.element = element;
        }

        public IHandle getElement() {
            return this.element;
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            return HandleDelta.equalsAndSameParent(this.element, ((Key)obj).element);
        }
    }
}

