/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.IBodyCache;
import org.eclipse.handly.model.impl.IWorkingCopyBuffer;
import org.eclipse.handly.model.impl.WorkingCopyInfo;

public class HandleManager {
    private IBodyCache cache;
    private ThreadLocal<Map<IHandle, Body>> temporaryCache = new ThreadLocal();
    private Map<ISourceFile, WorkingCopyInfo> workingCopyInfos = new HashMap<ISourceFile, WorkingCopyInfo>();

    public HandleManager(IBodyCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        this.cache = cache;
    }

    synchronized Body get(IHandle handle) {
        Body body;
        Map<IHandle, Body> tempCache = this.temporaryCache.get();
        if (tempCache != null && (body = tempCache.get(handle)) != null) {
            return body;
        }
        return this.cache.get(handle);
    }

    synchronized Body peek(IHandle handle) {
        Body body;
        Map<IHandle, Body> tempCache = this.temporaryCache.get();
        if (tempCache != null && (body = tempCache.get(handle)) != null) {
            return body;
        }
        return this.cache.peek(handle);
    }

    synchronized void put(IHandle handle, Map<IHandle, Body> newElements) {
        this.removeBodyAndChildren(handle);
        for (Map.Entry<IHandle, Body> entry : newElements.entrySet()) {
            this.cache.put(entry.getKey(), entry.getValue());
        }
    }

    synchronized void removeBodyAndChildren(IHandle handle) {
        Body body = this.cache.peek(handle);
        if (body != null) {
            IHandle[] children;
            IHandle[] iHandleArray = children = body.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IHandle child = iHandleArray[n2];
                this.removeBodyAndChildren(child);
                ++n2;
            }
            this.cache.remove(handle);
        }
    }

    Map<IHandle, Body> getTemporaryCache() {
        Map<IHandle, Body> result = this.temporaryCache.get();
        if (result == null) {
            result = new HashMap<IHandle, Body>();
            this.temporaryCache.set(result);
        }
        return result;
    }

    boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    synchronized boolean createWorkingCopyInfo(ISourceFile handle, IWorkingCopyBuffer buffer) {
        if (handle == null) {
            throw new IllegalArgumentException();
        }
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        boolean created = false;
        WorkingCopyInfo info = this.workingCopyInfos.get(handle);
        if (info == null) {
            info = new WorkingCopyInfo(buffer);
            this.workingCopyInfos.put(handle, info);
            created = true;
        } else if (!buffer.equals(info.getBuffer())) {
            throw new IllegalStateException("Already a working copy with another buffer");
        }
        info.addRef();
        return created;
    }

    synchronized WorkingCopyInfo getWorkingCopyInfo(ISourceFile handle) {
        WorkingCopyInfo info = this.workingCopyInfos.get(handle);
        if (info != null) {
            info.addRef();
        }
        return info;
    }

    synchronized WorkingCopyInfo peekAtWorkingCopyInfo(ISourceFile handle) {
        return this.workingCopyInfos.get(handle);
    }

    synchronized boolean discardWorkingCopyInfo(ISourceFile handle) {
        WorkingCopyInfo info = this.workingCopyInfos.get(handle);
        if (info == null || info.release() != 0) {
            return false;
        }
        this.workingCopyInfos.remove(handle);
        this.removeBodyAndChildren(handle);
        return true;
    }
}

