/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;

public abstract class SourceElement
extends Handle
implements ISourceElement {
    public SourceElement(Handle parent, String name) {
        super(parent, name);
        if (parent == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public ISourceElementInfo getSourceElementInfo() throws CoreException {
        return (ISourceElementInfo)((Object)this.getBody());
    }

    @Override
    public abstract SourceFile getSourceFile();

    static ISourceElement getElementAt(ISourceElement element, int position, ISnapshot base) throws CoreException {
        ISourceElementInfo info = element.getSourceElementInfo();
        if (base != null && !base.isEqualTo(info.getSnapshot())) {
            throw new StaleSnapshotException();
        }
        if (!info.getFullRange().covers(position)) {
            return null;
        }
        ISourceConstruct[] children = info.getChildren();
        int i = children.length - 1;
        while (i >= 0) {
            ISourceElement found = SourceElement.getElementAt(children[i], position, info.getSnapshot());
            if (found != null) {
                return found;
            }
            --i;
        }
        return element;
    }
}

