/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.handly.snapshot.TextFileSnapshot;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;

public final class TextFileBufferSnapshot
extends Snapshot {
    private ITextFileBuffer buffer;
    private ITextFileBufferManager bufferManager;
    private DocumentListener documentListener = new DocumentListener();
    private BufferListener bufferListener = new BufferListener();
    private Reference<String> contents;
    private TextFileSnapshot delegate;

    public TextFileBufferSnapshot(ITextFileBuffer buffer, ITextFileBufferManager bufferManager) {
        this.buffer = buffer;
        this.bufferManager = bufferManager;
        buffer.getDocument().addDocumentListener((IDocumentListener)this.documentListener);
        bufferManager.addFileBufferListener((IFileBufferListener)this.bufferListener);
    }

    @Override
    public synchronized String getContents() {
        String result;
        if (this.delegate != null) {
            return this.delegate.getContents();
        }
        String string = result = this.contents != null ? this.contents.get() : null;
        if (result == null && this.buffer != null) {
            result = this.buffer.getDocument().get();
            this.contents = new WeakReference<String>(result);
        }
        return result;
    }

    @Override
    protected synchronized Boolean predictEquality(Snapshot other) {
        if (this.delegate != null) {
            return this.delegate.isEqualTo(other);
        }
        if (this.contents == null && this.buffer == null) {
            return false;
        }
        if (other instanceof TextFileBufferSnapshot && this.buffer != null && this.buffer == ((TextFileBufferSnapshot)other).buffer) {
            return true;
        }
        return null;
    }

    private synchronized void bufferChanged() {
        if (this.buffer == null) {
            return;
        }
        this.removeListeners();
        this.bufferManager = null;
        this.contents = null;
        this.buffer = null;
    }

    private synchronized void bufferClosed() {
        if (this.buffer == null) {
            return;
        }
        this.removeListeners();
        this.bufferManager = null;
        TextFileSnapshot fileSnapshot = new TextFileSnapshot(ResourcesPlugin.getWorkspace().getRoot().getFile(this.buffer.getLocation()));
        if (!this.buffer.isDirty() && this.buffer.isSynchronized()) {
            this.delegate = fileSnapshot;
        }
        this.contents = null;
        this.buffer = null;
    }

    private synchronized void removeListeners() {
        if (this.documentListener != null) {
            this.buffer.getDocument().removeDocumentListener((IDocumentListener)this.documentListener);
            this.documentListener = null;
        }
        if (this.bufferListener != null) {
            this.bufferManager.removeFileBufferListener((IFileBufferListener)this.bufferListener);
            this.bufferListener = null;
        }
    }

    private class BufferListener
    implements IFileBufferListener {
        private BufferListener() {
        }

        public void bufferCreated(IFileBuffer buffer) {
        }

        public void bufferDisposed(IFileBuffer buffer) {
            if (TextFileBufferSnapshot.this.buffer == buffer) {
                TextFileBufferSnapshot.this.bufferClosed();
            }
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            TextFileBufferSnapshot.this.bufferChanged();
        }

        public void documentChanged(DocumentEvent event) {
        }
    }
}

