/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class LruCache<K, V>
implements Cloneable {
    protected static final int DEFAULT_SPACELIMIT = 100;
    protected int currentSpace = 0;
    protected int spaceLimit;
    protected int timestampCounter = 0;
    protected Hashtable<K, LruCacheEntry<K, V>> entryTable;
    protected LruCacheEntry<K, V> entryQueue = null;
    protected LruCacheEntry<K, V> entryQueueTail = null;

    public LruCache() {
        this(100);
    }

    public LruCache(int size) {
        this.entryTable = new Hashtable(size);
        this.spaceLimit = size;
    }

    public Object clone() {
        LruCache newCache = this.newInstance(this.spaceLimit);
        LruCacheEntry<K, V> qEntry = this.entryQueueTail;
        while (qEntry != null) {
            newCache.privateAdd(qEntry.key, qEntry.value, qEntry.space);
            qEntry = qEntry.previous;
        }
        return newCache;
    }

    public V get(Object key) {
        LruCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        this.updateTimestamp(entry);
        return entry.value;
    }

    public V peek(Object key) {
        LruCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    public K getKey(K key) {
        LruCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return key;
        }
        return entry.key;
    }

    public Enumeration<K> keys() {
        return this.entryTable.keys();
    }

    public ICacheEnumeration<K, V> keysAndValues() {
        return new ICacheEnumeration<K, V>(){
            Enumeration<LruCacheEntry<K, V>> values;
            LruCacheEntry<K, V> entry;
            {
                this.values = LruCache.this.entryTable.elements();
            }

            @Override
            public boolean hasMoreElements() {
                return this.values.hasMoreElements();
            }

            @Override
            public K nextElement() {
                this.entry = this.values.nextElement();
                return this.entry.key;
            }

            @Override
            public V getValue() {
                if (this.entry == null) {
                    throw new NoSuchElementException();
                }
                return this.entry.value;
            }
        };
    }

    public V put(K key, V value) {
        int newSpace = this.spaceFor(value);
        LruCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry != null) {
            int oldSpace = entry.space;
            int newTotal = this.getCurrentSpace() - oldSpace + newSpace;
            if (newTotal <= this.getSpaceLimit()) {
                this.updateTimestamp(entry);
                entry.value = value;
                entry.space = newSpace;
                this.currentSpace = newTotal;
                return value;
            }
            this.privateRemoveEntry(entry, false);
        }
        if (this.makeSpace(newSpace)) {
            this.privateAdd(key, value, newSpace);
        }
        return value;
    }

    public V remove(Object key) {
        LruCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        Object value = entry.value;
        this.privateRemoveEntry(entry, false);
        return value;
    }

    public void flush() {
        this.currentSpace = 0;
        LruCacheEntry<K, V> entry = this.entryQueueTail;
        this.entryTable = new Hashtable();
        this.entryQueueTail = null;
        this.entryQueue = null;
        while (entry != null) {
            entry = entry.previous;
        }
    }

    public double fillingRatio() {
        return (double)this.currentSpace * 100.0 / (double)this.spaceLimit;
    }

    public int getCurrentSpace() {
        return this.currentSpace;
    }

    public int getNewestTimestampCounter() {
        return this.entryQueue == null ? 0 : this.entryQueue.timestamp;
    }

    public int getOldestTimestampCounter() {
        return this.entryQueueTail == null ? 0 : this.entryQueueTail.timestamp;
    }

    public K getOldestElement() {
        return this.entryQueueTail == null ? null : (K)this.entryQueueTail.key;
    }

    public int getSpaceLimit() {
        return this.spaceLimit;
    }

    public void setSpaceLimit(int limit) {
        if (limit < this.spaceLimit) {
            this.makeSpace(this.spaceLimit - limit);
        }
        this.spaceLimit = limit;
    }

    public String toString() {
        return String.valueOf(this.toStringFillingRation("LruCache")) + this.toStringContents();
    }

    public String toStringFillingRation(String cacheName) {
        StringBuffer buffer = new StringBuffer(cacheName);
        buffer.append('[');
        buffer.append(this.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.fillingRatio()));
        buffer.append("% full");
        return buffer.toString();
    }

    protected LruCache<K, V> newInstance(int size) {
        return new LruCache<K, V>(size);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean makeSpace(int space) {
        limit = this.getSpaceLimit();
        if (this.currentSpace + space <= limit) {
            return true;
        }
        if (space <= limit) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            this.privateRemoveEntry(this.entryQueueTail, false);
lbl7:
            // 2 sources

            ** while (this.currentSpace + space > limit && this.entryQueueTail != null)
        }
lbl8:
        // 1 sources

        return true;
    }

    protected void privateAdd(K key, V value, int space) {
        LruCacheEntry<K, V> entry = new LruCacheEntry<K, V>(key, value, space);
        this.privateAddEntry(entry, false);
    }

    protected void privateAddEntry(LruCacheEntry<K, V> entry, boolean shuffle) {
        if (!shuffle) {
            this.entryTable.put(entry.key, entry);
            this.currentSpace += entry.space;
        }
        entry.timestamp = this.timestampCounter++;
        entry.next = this.entryQueue;
        entry.previous = null;
        if (this.entryQueue == null) {
            this.entryQueueTail = entry;
        } else {
            this.entryQueue.previous = entry;
        }
        this.entryQueue = entry;
    }

    protected void privateRemoveEntry(LruCacheEntry<K, V> entry, boolean shuffle) {
        LruCacheEntry previous = entry.previous;
        LruCacheEntry next = entry.next;
        if (!shuffle) {
            this.entryTable.remove(entry.key);
            this.currentSpace -= entry.space;
        }
        if (previous == null) {
            this.entryQueue = next;
        } else {
            previous.next = next;
        }
        if (next == null) {
            this.entryQueueTail = previous;
        } else {
            next.previous = previous;
        }
    }

    protected void updateTimestamp(LruCacheEntry<K, V> entry) {
        entry.timestamp = this.timestampCounter++;
        if (this.entryQueue != entry) {
            this.privateRemoveEntry(entry, true);
            this.privateAddEntry(entry, true);
        }
    }

    protected int spaceFor(V value) {
        return 1;
    }

    protected String toStringContents() {
        StringBuffer result = new StringBuffer();
        int length = this.entryTable.size();
        Object[] unsortedKeys = new Object[length];
        String[] unsortedToStrings = new String[length];
        Enumeration<K> e = this.keys();
        int i = 0;
        while (i < length) {
            K key = e.nextElement();
            unsortedKeys[i] = key;
            unsortedToStrings[i] = key.toString();
            ++i;
        }
        ToStringSorter sorter = new ToStringSorter();
        sorter.sort(unsortedKeys, unsortedToStrings);
        int i2 = 0;
        while (i2 < length) {
            String toString = sorter.sortedStrings[i2];
            V value = this.get(sorter.sortedObjects[i2]);
            result.append(toString);
            result.append(" -> ");
            result.append(value);
            result.append("\n");
            ++i2;
        }
        return result.toString();
    }

    public static interface ICacheEnumeration<K, V>
    extends Enumeration<K> {
        public V getValue();
    }

    protected static class LruCacheEntry<K, V> {
        public K key;
        public V value;
        public int timestamp;
        public int space;
        public LruCacheEntry<K, V> previous;
        public LruCacheEntry<K, V> next;

        public LruCacheEntry(K key, V value, int space) {
            this.key = key;
            this.value = value;
            this.space = space;
        }

        public String toString() {
            return "LRUCacheEntry [" + this.key + "-->" + this.value + "]";
        }
    }

    public class Stats {
        private int[] counters = new int[20];
        private long[] timestamps = new long[20];
        private int counterIndex = -1;

        public synchronized String printStats() {
            int numberOfElements = LruCache.this.currentSpace;
            if (numberOfElements == 0) {
                return "No elements in cache";
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("Number of elements in cache: ");
            buffer.append(numberOfElements);
            int numberOfGroups = 5;
            int numberOfElementsPerGroup = numberOfElements / 5;
            buffer.append("\n(");
            buffer.append(5);
            buffer.append(" groups of ");
            buffer.append(numberOfElementsPerGroup);
            buffer.append(" elements)");
            buffer.append("\n\nAverage age:");
            int groupNumber = 1;
            int elementCounter = 0;
            LruCacheEntry entry = LruCache.this.entryQueueTail;
            long currentTime = System.currentTimeMillis();
            long accumulatedTime = 0L;
            while (entry != null) {
                long timeStamps = this.getTimestamps(entry.timestamp);
                if (timeStamps > 0L) {
                    accumulatedTime += timeStamps;
                    ++elementCounter;
                }
                if (elementCounter >= numberOfElementsPerGroup && groupNumber < 5) {
                    buffer.append("\nGroup ");
                    buffer.append(groupNumber);
                    if (groupNumber == 1) {
                        buffer.append(" (oldest)\t: ");
                    } else {
                        buffer.append("\t\t: ");
                    }
                    ++groupNumber;
                    buffer.append(this.getAverageAge(accumulatedTime, elementCounter, currentTime));
                    elementCounter = 0;
                    accumulatedTime = 0L;
                }
                entry = entry.previous;
            }
            buffer.append("\nGroup ");
            buffer.append(5);
            buffer.append(" (youngest)\t: ");
            buffer.append(this.getAverageAge(accumulatedTime, elementCounter, currentTime));
            return buffer.toString();
        }

        public synchronized void snapshot() {
            this.removeCountersOlderThan(LruCache.this.getOldestTimestampCounter());
            this.add(LruCache.this.getNewestTimestampCounter());
        }

        public Object getOldestElement() {
            return LruCache.this.getOldestElement();
        }

        public long getOldestTimestamps() {
            return this.getTimestamps(LruCache.this.getOldestTimestampCounter());
        }

        private void add(int counter) {
            int i = 0;
            while (i <= this.counterIndex) {
                if (this.counters[i] == counter) {
                    return;
                }
                ++i;
            }
            int length = this.counters.length;
            if (++this.counterIndex == length) {
                int newLength = this.counters.length * 2;
                this.counters = new int[newLength];
                System.arraycopy(this.counters, 0, this.counters, 0, length);
                this.timestamps = new long[newLength];
                System.arraycopy(this.timestamps, 0, this.timestamps, 0, length);
            }
            this.counters[this.counterIndex] = counter;
            this.timestamps[this.counterIndex] = System.currentTimeMillis();
        }

        private String getAverageAge(long totalTime, int numberOfElements, long currentTime) {
            if (numberOfElements == 0) {
                return "N/A";
            }
            long time = totalTime / (long)numberOfElements;
            long age = currentTime - time;
            long ageInSeconds = age / 1000L;
            int seconds = 0;
            int minutes = 0;
            int hours = 0;
            int days = 0;
            if (ageInSeconds > 60L) {
                long ageInMin = ageInSeconds / 60L;
                seconds = (int)(ageInSeconds - 60L * ageInMin);
                if (ageInMin > 60L) {
                    long ageInHours = ageInMin / 60L;
                    minutes = (int)(ageInMin - 60L * ageInHours);
                    if (ageInHours > 24L) {
                        long ageInDays = ageInHours / 24L;
                        hours = (int)(ageInHours - 24L * ageInDays);
                        days = (int)ageInDays;
                    } else {
                        hours = (int)ageInHours;
                    }
                } else {
                    minutes = (int)ageInMin;
                }
            } else {
                seconds = (int)ageInSeconds;
            }
            StringBuffer buffer = new StringBuffer();
            if (days > 0) {
                buffer.append(days);
                buffer.append(" days ");
            }
            if (hours > 0) {
                buffer.append(hours);
                buffer.append(" hours ");
            }
            if (minutes > 0) {
                buffer.append(minutes);
                buffer.append(" minutes ");
            }
            buffer.append(seconds);
            buffer.append(" seconds");
            return buffer.toString();
        }

        private long getTimestamps(int counter) {
            int i = 0;
            while (i <= this.counterIndex) {
                if (this.counters[i] >= counter) {
                    return this.timestamps[i];
                }
                ++i;
            }
            return -1L;
        }

        private void removeCountersOlderThan(int counter) {
            int i = 0;
            while (i <= this.counterIndex) {
                if (this.counters[i] >= counter) {
                    if (i > 0) {
                        int length = this.counterIndex - i + 1;
                        System.arraycopy(this.counters, i, this.counters, 0, length);
                        System.arraycopy(this.timestamps, i, this.timestamps, 0, length);
                        this.counterIndex = length;
                    }
                    return;
                }
                ++i;
            }
        }
    }

    protected static class ToStringSorter {
        private Object[] sortedObjects;
        private String[] sortedStrings;

        protected ToStringSorter() {
        }

        public void sort(Object[] unSortedObjects, String[] unsortedStrings) {
            int size = unSortedObjects.length;
            this.sortedObjects = new Object[size];
            this.sortedStrings = new String[size];
            System.arraycopy(unSortedObjects, 0, this.sortedObjects, 0, size);
            System.arraycopy(unsortedStrings, 0, this.sortedStrings, 0, size);
            if (size > 1) {
                this.quickSort(0, size - 1);
            }
        }

        public boolean compare(String stringOne, String stringTwo) {
            return stringOne.compareTo(stringTwo) < 0;
        }

        private void quickSort(int left, int right) {
            int originalLeft = left;
            int originalRight = right;
            int midIndex = left + (right - left) / 2;
            String midToString = this.sortedStrings[midIndex];
            while (true) {
                if (this.compare(this.sortedStrings[left], midToString)) {
                    ++left;
                    continue;
                }
                while (this.compare(midToString, this.sortedStrings[right])) {
                    --right;
                }
                if (left <= right) {
                    Object tmp = this.sortedObjects[left];
                    this.sortedObjects[left] = this.sortedObjects[right];
                    this.sortedObjects[right] = tmp;
                    String tmpToString = this.sortedStrings[left];
                    this.sortedStrings[left] = this.sortedStrings[right];
                    this.sortedStrings[right] = tmpToString;
                    ++left;
                    --right;
                }
                if (left > right) break;
            }
            if (originalLeft < right) {
                this.quickSort(originalLeft, right);
            }
            if (left < originalRight) {
                this.quickSort(left, originalRight);
            }
        }
    }
}

