/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.internal.ui.SourceElementUtil;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.ui.IElementForEditorInputFactory;
import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.OutlineLinkingHelper;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class SourceElementLinkingHelper
extends OutlineLinkingHelper {
    protected final IElementForEditorInputFactory inputElementFactory;
    private LinkToOutlineJob linkToOutlineJob = new LinkToOutlineJob();

    public SourceElementLinkingHelper(ICommonOutlinePage outlinePage, IElementForEditorInputFactory factory) {
        super(outlinePage);
        this.inputElementFactory = factory;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cancelLinkToOutlineJob();
    }

    @Override
    protected final void linkToOutline(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        this.scheduleLinkToOutlineJob(selection);
    }

    protected void linkToEditor(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        IEditorPart editor = this.getTargetEditor();
        if (editor instanceof ITextEditor) {
            this.linkToEditor((ITextEditor)editor, (IStructuredSelection)selection);
        } else {
            editor.getSite().getSelectionProvider().setSelection(selection);
        }
    }

    protected void linkToEditor(ITextEditor editor, IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (!(element instanceof ISourceElement)) {
            return;
        }
        ISourceElement sourceElement = (ISourceElement)element;
        if (!this.isInEditor((IHandle)sourceElement, (IEditorPart)editor)) {
            return;
        }
        TextRange identifyingRange = SourceElementUtil.getIdentifyingRange(sourceElement);
        if (identifyingRange == null) {
            return;
        }
        editor.selectAndReveal(identifyingRange.getOffset(), identifyingRange.getLength());
    }

    protected IStructuredSelection getLinkedSelection(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return this.getLinkedSelection((ITextSelection)selection);
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected IStructuredSelection getLinkedSelection(ITextSelection selection) {
        Object input = this.getOutlinePage().getTreeViewer().getInput();
        if (!(input instanceof ISourceElement)) {
            return null;
        }
        ISourceElement element = SourceElementUtil.getElementAt((ISourceElement)input, selection.getOffset());
        if (element == null) {
            return null;
        }
        return new StructuredSelection((Object)element);
    }

    protected IEditorPart getTargetEditor() {
        IEditorPart editor = this.getOutlinePage().getEditor();
        while (editor instanceof IPageChangeProvider) {
            Object page = ((IPageChangeProvider)editor).getSelectedPage();
            if (!(page instanceof IEditorPart)) break;
            editor = (IEditorPart)page;
        }
        return editor;
    }

    protected boolean isInEditor(IHandle element, IEditorPart editor) {
        IHandle inputElement = this.inputElementFactory.getElement(editor.getEditorInput());
        while (element != null) {
            if (element.equals((Object)inputElement)) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    private void cancelLinkToOutlineJob() {
        this.linkToOutlineJob.cancel();
        this.linkToOutlineJob.setSelection(null);
    }

    private void scheduleLinkToOutlineJob(ISelection selection) {
        this.linkToOutlineJob.cancel();
        this.linkToOutlineJob.setSelection(selection);
        this.linkToOutlineJob.schedule();
    }

    private class LinkToOutlineJob
    extends Job {
        private volatile ISelection selection;

        public LinkToOutlineJob() {
            super("");
            this.setSystem(true);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        protected IStatus run(IProgressMonitor monitor) {
            final ISelection baseSelection = this.selection;
            if (baseSelection == null || baseSelection.isEmpty()) {
                return Status.OK_STATUS;
            }
            Object baseInput = SourceElementLinkingHelper.this.getOutlinePage().getTreeViewer().getInput();
            if (!(baseInput instanceof ISourceElement)) {
                return Status.OK_STATUS;
            }
            final IStructuredSelection linkedSelection = SourceElementLinkingHelper.this.getLinkedSelection(baseSelection);
            if (linkedSelection == null) {
                return Status.OK_STATUS;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Control control = SourceElementLinkingHelper.this.getOutlinePage().getControl();
                    TreeViewer treeViewer = SourceElementLinkingHelper.this.getOutlinePage().getTreeViewer();
                    IEditorPart editor = SourceElementLinkingHelper.this.getOutlinePage().getEditor();
                    if (control == null || control.isDisposed() || !baseSelection.equals(LinkToOutlineJob.this.selection) || !baseSelection.equals(editor.getSite().getSelectionProvider().getSelection())) {
                        return;
                    }
                    IStructuredSelection currentSelection = (IStructuredSelection)treeViewer.getSelection();
                    if (currentSelection == null || !currentSelection.toList().containsAll(linkedSelection.toList())) {
                        treeViewer.setSelection((ISelection)linkedSelection, true);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

