/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.text.reconciler;

import org.eclipse.handly.ui.IWorkingCopyManager;
import org.eclipse.handly.ui.WorkingCopyProvider;
import org.eclipse.handly.ui.text.reconciler.BaseReconciler;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class HandlyReconciler
extends BaseReconciler {
    protected final ITextEditor editor;
    private final IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part == HandlyReconciler.this.editor) {
                HandlyReconciler.this.setActive(true);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == HandlyReconciler.this.editor) {
                HandlyReconciler.this.setActive(false);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    };

    public HandlyReconciler(ITextEditor editor, IWorkingCopyManager manager) {
        super(new WorkingCopyProvider((IEditorPart)editor, manager));
        this.editor = editor;
    }

    @Override
    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        IWorkbenchPartSite site = this.editor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().addPartListener(this.partListener);
    }

    @Override
    public void uninstall() {
        IWorkbenchPartSite site = this.editor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().removePartListener(this.partListener);
        super.uninstall();
    }

    @Override
    protected Object getReconcilerLock() {
        return this.editor;
    }
}

