/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.viewer;

import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public abstract class ProblemLabelDecorator
implements ILabelDecorator {
    private ResourceManager resourceManager;

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return null;
        }
        Severity severity = this.computeProblemSeverity(element);
        if (severity == null) {
            return null;
        }
        return (Image)this.getResourceManager().get((DeviceResourceDescriptor)new DecorationOverlayIcon(image, this.getOverlayImage(severity), 2));
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected abstract Severity computeProblemSeverity(Object var1);

    private ImageDescriptor getOverlayImage(Severity severity) {
        switch (severity) {
            case ERROR: {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
            }
            case WARNING: {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING");
            }
        }
        throw new AssertionError();
    }

    private ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    protected static enum Severity {
        ERROR,
        WARNING;


        public static Severity max(Severity a, Severity b) {
            if (a == ERROR) {
                return a;
            }
            if (a == WARNING && b != ERROR) {
                return a;
            }
            return b;
        }
    }
}

