/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import junit.framework.TestCase;
import org.eclipse.handly.util.LruCache;
import org.eclipse.handly.util.OverflowingLruCache;

public class OverflowingCacheTest
extends TestCase {
    public void testCacheFill() {
        int spaceLimit = 500;
        int overflow = 0;
        int current = 0;
        ElementCache cache = new ElementCache(spaceLimit);
        Element[] elements = new Element[spaceLimit];
        int i = 0;
        while (i < spaceLimit) {
            elements[i] = new Element(false, cache);
            cache.put(elements[i], i);
            ++current;
            ++i;
        }
        int actualSpaceLimit = cache.getSpaceLimit();
        OverflowingCacheTest.assertEquals((String)"space limit incorrect", (int)spaceLimit, (int)actualSpaceLimit);
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTest.assertEquals((String)"current space incorrect", (int)current, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTest.assertEquals((String)"overflow space incorrect", (int)overflow, (int)actualOverflow);
        i = spaceLimit - 1;
        while (i >= 0) {
            Integer value = (Integer)cache.get(elements[i]);
            OverflowingCacheTest.assertEquals((String)"wrong value", (Object)new Integer(i), (Object)value);
            --i;
        }
    }

    public void testCacheUseNoOverflow() {
        Integer value;
        int spaceLimit = 500;
        int overflow = 0;
        int predictedCurrent = 334;
        int entryCount = 1000;
        ElementCache cache = new ElementCache(spaceLimit);
        Element[] elements = new Element[entryCount];
        int i = 0;
        while (i < entryCount) {
            elements[i] = new Element(false, cache);
            cache.put(elements[i], i);
            ++i;
        }
        int actualSpaceLimit = cache.getSpaceLimit();
        OverflowingCacheTest.assertEquals((String)"space limit incorrect", (int)spaceLimit, (int)actualSpaceLimit);
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTest.assertEquals((String)"current space incorrect", (int)predictedCurrent, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTest.assertEquals((String)"overflow space incorrect", (int)overflow, (int)actualOverflow);
        i = entryCount - 1;
        while (i >= entryCount - predictedCurrent) {
            value = (Integer)cache.get(elements[i]);
            OverflowingCacheTest.assertEquals((String)"wrong value", (Object)new Integer(i), (Object)value);
            --i;
        }
        i = 0;
        while (i < entryCount - predictedCurrent) {
            value = (Integer)cache.get(elements[i]);
            OverflowingCacheTest.assertNull((String)"entry should not be present", (Object)value);
            ++i;
        }
    }

    public void testCacheUseOverflow() {
        int spaceLimit = 500;
        int entryCount = 1000;
        ElementCache cache = new ElementCache(spaceLimit);
        Element[] elements = new Element[entryCount];
        int i = 0;
        while (i < entryCount) {
            elements[i] = new Element(this.hasUnsavedChanges(i), cache);
            cache.put(elements[i], i);
            ++i;
        }
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTest.assertEquals((String)"current space incorrect", (int)900, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTest.assertEquals((String)"overflow space incorrect", (int)400, (int)actualOverflow);
        int i2 = entryCount - 1;
        while (i2 >= 0) {
            Integer value = (Integer)cache.get(elements[i2]);
            if (this.hasUnsavedChanges(i2)) {
                OverflowingCacheTest.assertEquals((String)"wrong value", (Object)new Integer(i2), (Object)value);
            } else {
                OverflowingCacheTest.assertNull((String)"entry should not be present", (Object)value);
            }
            --i2;
        }
        i2 = 0;
        while (i2 < entryCount) {
            elements[i2].save();
            ++i2;
        }
        cache.put(new Element(false, cache), 1001);
        actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTest.assertEquals((String)"current space incorrect (after flush)", (int)168, (int)actualCurrent);
        actualOverflow = cache.getOverflow();
        OverflowingCacheTest.assertEquals((String)"overflow space incorrect (after flush)", (int)0, (int)actualOverflow);
    }

    private boolean hasUnsavedChanges(int i) {
        return i % 10 != 0;
    }

    private static class Element {
        private boolean hasUnsavedChanges;
        private ElementCache cache;

        public Element(boolean hasUnsavedChanges, ElementCache cache) {
            this.hasUnsavedChanges = hasUnsavedChanges;
            this.cache = cache;
        }

        public void save() {
            this.hasUnsavedChanges = false;
        }

        public boolean close() {
            if (this.hasUnsavedChanges) {
                return false;
            }
            this.cache.remove(this);
            return true;
        }
    }

    private static class ElementCache
    extends OverflowingLruCache<Element, Integer> {
        public ElementCache(int size) {
            super(size);
        }

        public ElementCache(int size, int overflow) {
            super(size, overflow);
        }

        protected boolean close(LruCache.LruCacheEntry<Element, Integer> entry) {
            return ((Element)entry.key).close();
        }

        protected OverflowingLruCache<Element, Integer> newInstance(int size, int newOverflow) {
            return new ElementCache(size, newOverflow);
        }
    }
}

