/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooElement;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class FooContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFooProject) {
            try {
                Object[] children = ((IFooElement)parentElement).getChildren();
                Object[] nonFooResources = ((IFooProject)parentElement).getNonFooResources();
                return FooContentProvider.concat(children, nonFooResources);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (parentElement instanceof IFooElement) {
            try {
                return ((IFooElement)parentElement).getChildren();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (parentElement instanceof IFolder) {
            try {
                return ((IFolder)parentElement).members();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (element instanceof IFooElement) {
            return ((IFooElement)element).getParent();
        }
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            if (parent instanceof IFolder) {
                return parent;
            }
            if (parent instanceof IProject) {
                return FooModelCore.create((IResource)parent);
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    private static Object[] concat(Object[] a, Object[] b) {
        Object[] c = new Object[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }
}

