/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooElement;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.internal.examples.basic.ui.model.FooProjectBody;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.HandleDelta;

class FooDeltaProcessor
implements IResourceDeltaVisitor {
    private HandleDelta currentDelta = new HandleDelta((IHandle)FooModelCore.getFooModel());
    private Set<String> oldFooProjectNames = new HashSet<String>();

    FooDeltaProcessor() {
    }

    public HandleDelta getDelta() {
        return this.currentDelta;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        switch (delta.getResource().getType()) {
            case 8: {
                return this.processRoot(delta);
            }
            case 4: {
                return this.processProject(delta);
            }
            case 2: {
                return this.processFolder(delta);
            }
            case 1: {
                return this.processFile(delta);
            }
        }
        return true;
    }

    private boolean processRoot(IResourceDelta delta) throws CoreException {
        this.initOldFooProjectNames();
        if ((delta.getFlags() & 0x20000) != 0) {
            this.markersChanged(FooModelCore.getFooModel(), delta.getMarkerDeltas());
        }
        return true;
    }

    private boolean processProject(IResourceDelta delta) throws CoreException {
        switch (delta.getKind()) {
            case 1: {
                return this.processAddedProject(delta);
            }
            case 2: {
                return this.processRemovedProject(delta);
            }
            case 4: {
                return this.processChangedProject(delta);
            }
        }
        return true;
    }

    private boolean processAddedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        if (project.hasNature("org.eclipse.handly.examples.basic.ui.fooNature")) {
            IFooProject fooProject = FooModelCore.create(project);
            this.addToModel(fooProject);
            this.translateAddedDelta(delta, fooProject);
        } else {
            this.addResourceDelta(delta);
        }
        return false;
    }

    private boolean processRemovedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        if (this.wasFooProject(project)) {
            IFooProject fooProject = FooModelCore.create(project);
            this.removeFromModel(fooProject);
            this.translateRemovedDelta(delta, fooProject);
        } else {
            this.addResourceDelta(delta);
        }
        return false;
    }

    private boolean processChangedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        IFooProject fooProject = FooModelCore.create(project);
        if ((delta.getFlags() & 0x4000) != 0) {
            if (project.isOpen()) {
                if (project.hasNature("org.eclipse.handly.examples.basic.ui.fooNature")) {
                    this.addToModel(fooProject);
                    this.currentDelta.insertAdded((IHandle)fooProject, 64);
                } else {
                    this.addResourceDelta(delta);
                }
            } else if (this.wasFooProject(project)) {
                this.removeFromModel(fooProject);
                this.currentDelta.insertRemoved((IHandle)fooProject, 64);
            } else {
                this.addResourceDelta(delta);
            }
            return false;
        }
        boolean isFooProject = project.hasNature("org.eclipse.handly.examples.basic.ui.fooNature");
        if ((delta.getFlags() & 0x80000) != 0) {
            boolean wasFooProject = this.wasFooProject(project);
            if (wasFooProject != isFooProject) {
                if (isFooProject) {
                    this.addToModel(fooProject);
                    this.currentDelta.insertAdded((IHandle)fooProject, 128);
                } else {
                    this.removeFromModel(fooProject);
                    this.currentDelta.insertRemoved((IHandle)fooProject, 128);
                }
                return false;
            }
            if (isFooProject) {
                this.currentDelta.insertChanged((IHandle)fooProject, 128);
            }
        }
        if (isFooProject) {
            Body parentBody;
            IHandle[] children;
            if ((delta.getFlags() & 0x20000) != 0) {
                this.markersChanged(fooProject, delta.getMarkerDeltas());
            }
            if (!Arrays.asList(children = (parentBody = FooDeltaProcessor.findBody(fooProject.getParent())).getChildren()).contains(fooProject)) {
                this.addToModel(fooProject);
            }
            return true;
        }
        this.addResourceDelta(delta);
        return false;
    }

    private boolean processFolder(IResourceDelta delta) {
        this.addResourceDelta(delta);
        return false;
    }

    private boolean processFile(IResourceDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                return this.processAddedFile(delta);
            }
            case 2: {
                return this.processRemovedFile(delta);
            }
            case 4: {
                return this.processChangedFile(delta);
            }
        }
        return false;
    }

    private boolean processAddedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IFooFile fooFile = FooModelCore.create(file);
        if (fooFile != null) {
            this.addToModel(fooFile);
            this.translateAddedDelta(delta, fooFile);
        } else {
            this.addResourceDelta(delta);
        }
        return false;
    }

    private boolean processRemovedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IFooFile fooFile = FooModelCore.create(file);
        if (fooFile != null) {
            this.removeFromModel(fooFile);
            this.translateRemovedDelta(delta, fooFile);
        } else {
            this.addResourceDelta(delta);
        }
        return false;
    }

    private boolean processChangedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IFooFile fooFile = FooModelCore.create(file);
        if (fooFile != null) {
            if ((delta.getFlags() & 0xFFFCFFFF) != 0) {
                this.contentChanged(fooFile);
            }
            if ((delta.getFlags() & 0x20000) != 0) {
                this.markersChanged(fooFile, delta.getMarkerDeltas());
            }
            if ((delta.getFlags() & 0x10000) != 0) {
                this.currentDelta.insertChanged((IHandle)fooFile, 2048);
            }
        } else {
            this.addResourceDelta(delta);
        }
        return false;
    }

    private void initOldFooProjectNames() throws CoreException {
        IFooProject[] fooProjects;
        IFooProject[] iFooProjectArray = fooProjects = FooModelCore.getFooModel().getFooProjects();
        int n = fooProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IFooProject fooProject = iFooProjectArray[n2];
            this.oldFooProjectNames.add(fooProject.getName());
            ++n2;
        }
    }

    private boolean wasFooProject(IProject project) {
        return this.oldFooProjectNames.contains(project.getName());
    }

    private void addToModel(IFooElement element) {
        Body parentBody = FooDeltaProcessor.findBody(element.getParent());
        if (parentBody != null) {
            parentBody.addChild((IHandle)element);
        }
        FooDeltaProcessor.close(element);
    }

    private void removeFromModel(IFooElement element) {
        Body parentBody = FooDeltaProcessor.findBody(element.getParent());
        if (parentBody != null) {
            parentBody.removeChild((IHandle)element);
        }
        FooDeltaProcessor.close(element);
    }

    private void translateAddedDelta(IResourceDelta delta, IFooElement element) {
        if ((delta.getFlags() & 0x1000) == 0) {
            this.currentDelta.insertAdded((IHandle)element);
        } else {
            IFooElement movedFromElement = FooModelCore.create(FooDeltaProcessor.getResource(delta.getMovedFromPath(), delta.getResource().getType()));
            if (movedFromElement == null) {
                this.currentDelta.insertAdded((IHandle)element);
            } else {
                this.currentDelta.insertMovedTo((IHandle)element, (IHandle)movedFromElement);
            }
        }
    }

    private void translateRemovedDelta(IResourceDelta delta, IFooElement element) {
        if ((delta.getFlags() & 0x2000) == 0) {
            this.currentDelta.insertRemoved((IHandle)element);
        } else {
            IFooElement movedToElement = FooModelCore.create(FooDeltaProcessor.getResource(delta.getMovedToPath(), delta.getResource().getType()));
            if (movedToElement == null) {
                this.currentDelta.insertRemoved((IHandle)element);
            } else {
                this.currentDelta.insertMovedFrom((IHandle)element, (IHandle)movedToElement);
            }
        }
    }

    private void contentChanged(IFooFile fooFile) {
        if (fooFile.isWorkingCopy()) {
            this.currentDelta.insertChanged((IHandle)fooFile, 513);
            return;
        }
        FooDeltaProcessor.close(fooFile);
        this.currentDelta.insertChanged((IHandle)fooFile, 1);
    }

    private void markersChanged(IFooElement fooElement, IMarkerDelta[] markerDeltas) {
        HandleDelta delta = this.currentDelta.getDeltaFor((IHandle)fooElement);
        if (delta == null) {
            delta = new HandleDelta((IHandle)fooElement);
            this.currentDelta.insert(delta);
        }
        delta.setMarkerDeltas(markerDeltas);
    }

    private void addResourceDelta(IResourceDelta delta) {
        HandleDelta handleDelta;
        IContainer parent = delta.getResource().getParent();
        if (parent instanceof IWorkspaceRoot) {
            handleDelta = this.currentDelta;
        } else if (parent instanceof IProject) {
            FooProjectBody body;
            IFooProject fooProject = FooModelCore.create((IProject)parent);
            handleDelta = this.currentDelta.getDeltaFor((IHandle)fooProject);
            if (handleDelta == null) {
                handleDelta = new HandleDelta((IHandle)fooProject);
                this.currentDelta.insert(handleDelta);
            }
            if ((delta.getKind() & 3) != 0 && (body = (FooProjectBody)FooDeltaProcessor.findBody(fooProject)) != null) {
                body.setNonFooResources(null);
            }
        } else {
            throw new AssertionError();
        }
        handleDelta.addResourceDelta(delta);
    }

    private static Body findBody(IFooElement element) {
        return ((Handle)element).findBody();
    }

    private static void close(IFooElement element) {
        ((Handle)element).close();
    }

    private static IResource getResource(IPath fullPath, int resourceType) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        switch (resourceType) {
            case 8: {
                return root;
            }
            case 4: {
                return root.getProject(fullPath.lastSegment());
            }
            case 2: {
                return root.getFolder(fullPath);
            }
            case 1: {
                return root.getFile(fullPath);
            }
        }
        return null;
    }
}

