/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.internal.examples.basic.ui.Activator;
import org.eclipse.handly.internal.examples.basic.ui.model.FooDeltaProcessor;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModel;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModelCache;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IHandleDelta;
import org.eclipse.handly.model.impl.ElementChangeEvent;
import org.eclipse.handly.model.impl.HandleManager;
import org.eclipse.handly.model.impl.IBodyCache;

public class FooModelManager
implements IResourceChangeListener {
    public static final FooModelManager INSTANCE = new FooModelManager();
    private IFooModel fooModel;
    private HandleManager handleManager;
    private ListenerList listenerList;

    public void startup() throws Exception {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.fooModel = new FooModel(workspace);
            this.handleManager = new HandleManager((IBodyCache)new FooModelCache());
            this.listenerList = new ListenerList();
            workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            new SavedStateJob().schedule();
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.listenerList = null;
        this.handleManager = null;
        this.fooModel = null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        FooDeltaProcessor deltaProcessor = new FooDeltaProcessor();
        try {
            event.getDelta().accept((IResourceDeltaVisitor)deltaProcessor);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        if (!deltaProcessor.getDelta().isEmpty()) {
            this.fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(1, (IHandleDelta)deltaProcessor.getDelta()));
        }
    }

    public IFooModel getFooModel() {
        if (this.fooModel == null) {
            throw new IllegalStateException();
        }
        return this.fooModel;
    }

    public HandleManager getHandleManager() {
        if (this.handleManager == null) {
            throw new IllegalStateException();
        }
        return this.handleManager;
    }

    public void addElementChangeListener(IElementChangeListener listener) {
        if (this.listenerList == null) {
            throw new IllegalStateException();
        }
        this.listenerList.add((Object)listener);
    }

    public void removeElementChangeListener(IElementChangeListener listener) {
        if (this.listenerList == null) {
            throw new IllegalStateException();
        }
        this.listenerList.remove((Object)listener);
    }

    public void fireElementChangeEvent(final IElementChangeEvent event) {
        Object[] listeners;
        if (this.listenerList == null) {
            throw new IllegalStateException();
        }
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    ((IElementChangeListener)listener).elementChanged(event);
                }
            });
            ++n2;
        }
    }

    private FooModelManager() {
    }

    private static class SavedStateJob
    extends WorkspaceJob {
        public SavedStateJob() {
            super("SavedState");
            this.setSystem(true);
            this.setPriority(20);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            ISavedState savedState = ResourcesPlugin.getWorkspace().addSaveParticipant("org.eclipse.handly.examples.basic.ui", (ISaveParticipant)new SaveParticipant());
            if (savedState != null) {
                savedState.processResourceChangeEvents((IResourceChangeListener)INSTANCE);
            }
            return Status.OK_STATUS;
        }

        private static class SaveParticipant
        implements ISaveParticipant {
            private SaveParticipant() {
            }

            public void doneSaving(ISaveContext context) {
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void rollback(ISaveContext context) {
            }

            public void saving(ISaveContext context) throws CoreException {
                if (context.getKind() == 1) {
                    context.needDelta();
                }
            }
        }
    }
}

