/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooElement;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.internal.examples.basic.ui.SourceElementUtil;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class FooLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            IFooFile fooFile = FooModelCore.create(file);
            if (fooFile != null) {
                Object element;
                IStructuredSelection currentSelection;
                IViewPart navigatorView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.handly.examples.basic.ui.views.fooNavigator");
                if (navigatorView != null && (currentSelection = (IStructuredSelection)navigatorView.getSite().getSelectionProvider().getSelection()) != null && currentSelection.size() == 1 && (element = currentSelection.getFirstElement()) instanceof IFooElement && fooFile.equals(((IFooElement)element).getAncestor(IFooFile.class))) {
                    return currentSelection;
                }
                return new StructuredSelection((Object)fooFile);
            }
            return new StructuredSelection((Object)file);
        }
        return null;
    }

    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
        IEditorPart editor;
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        IFile file = FooLinkHelper.toFile(element);
        if (file != null && (editor = page.findEditor((IEditorInput)new FileEditorInput(file))) != null) {
            page.bringToTop((IWorkbenchPart)editor);
            FooLinkHelper.revealInEditor(editor, element);
        }
    }

    static IFile toFile(Object element) {
        IResource resource = null;
        if (element instanceof IFooElement) {
            resource = ((IFooElement)element).getResource();
        } else if (element instanceof IResource) {
            resource = (IResource)element;
        }
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    static void revealInEditor(IEditorPart editor, Object element) {
        if (editor instanceof ITextEditor && element instanceof ISourceElement) {
            SourceElementUtil.revealInTextEditor((ITextEditor)editor, (ISourceElement)element);
        }
    }
}

