/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.internal.examples.basic.ui.navigator.OpenAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenActionProvider
extends CommonActionProvider {
    private OpenAction openAction;

    public void init(ICommonActionExtensionSite actionSite) {
        super.init(actionSite);
        this.openAction = new OpenAction(this.getPage());
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.openAction == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.openAction.selectionChanged(selection);
        if (this.openAction.isEnabled()) {
            menu.insertAfter("group.open", (IAction)this.openAction);
        }
        this.addOpenWithMenu(menu);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openAction == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.openAction.selectionChanged(selection);
        if (this.openAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
    }

    private void addOpenWithMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        IFile file = null;
        if (element instanceof IFooFile) {
            file = ((IFooFile)element).getFile();
        } else if (element instanceof IFile) {
            file = (IFile)element;
        }
        if (file != null) {
            MenuManager submenu = new MenuManager("Open Wit&h");
            submenu.add((IContributionItem)new OpenWithMenu(this.getPage(), (IAdaptable)file));
            menu.appendToGroup("group.openWith", (IContributionItem)submenu);
        }
    }

    private IWorkbenchPage getPage() {
        return ((ICommonViewerWorkbenchSite)this.getActionSite().getViewSite()).getPage();
    }
}

