/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.IDocumentBuffer;
import org.eclipse.handly.buffer.UiBufferChangeRunner;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.TextFileBufferSnapshot;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;

public class TextFileBuffer
implements IDocumentBuffer {
    private volatile boolean closed;
    protected final IFile file;
    protected final ITextFileBufferManager bufferManager;
    protected final ITextFileBuffer buffer;

    public TextFileBuffer(IFile file, ITextFileBufferManager bufferManager, IProgressMonitor monitor) throws CoreException {
        this.file = file;
        if (this.file == null) {
            throw new IllegalArgumentException();
        }
        this.bufferManager = bufferManager;
        if (this.bufferManager == null) {
            throw new IllegalArgumentException();
        }
        bufferManager.connect(file.getFullPath(), LocationKind.IFILE, monitor);
        this.buffer = bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
    }

    @Override
    public IDocument getDocument() {
        this.checkNotClosed();
        return this.buffer.getDocument();
    }

    @Override
    public ISnapshot getSnapshot() {
        this.checkNotClosed();
        return new TextFileBufferSnapshot(this.buffer, this.bufferManager);
    }

    @Override
    public IBufferChange applyChange(IBufferChange change, IProgressMonitor monitor) throws CoreException {
        this.checkNotClosed();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BufferChangeOperation operation = this.createChangeOperation(change);
            if (!this.buffer.isSynchronizationContextRequested()) {
                return operation.execute(monitor);
            }
            UiBufferChangeRunner runner = new UiBufferChangeRunner(UiSynchronizer.DEFAULT, operation);
            return runner.run(monitor);
        }
        catch (MalformedTreeException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    @Override
    public void setContents(String contents) {
        this.checkNotClosed();
        this.buffer.getDocument().set(contents);
    }

    @Override
    public boolean hasUnsavedChanges() {
        this.checkNotClosed();
        return this.buffer.isDirty();
    }

    @Override
    public boolean mustSaveChanges() {
        this.checkNotClosed();
        return this.buffer.isDirty() && !this.buffer.isShared();
    }

    @Override
    public void save(boolean overwrite, IProgressMonitor monitor) throws CoreException {
        this.checkNotClosed();
        this.buffer.commit(monitor, overwrite);
    }

    @Override
    public void dispose() {
        this.checkNotClosed();
        this.closed = true;
        try {
            this.bufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextFileBuffer other = (TextFileBuffer)obj;
        return this.buffer == other.buffer;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void checkNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("the buffer has been closed");
        }
    }

    protected BufferChangeOperation createChangeOperation(IBufferChange change) {
        return new BufferChangeOperation(this, change);
    }
}

