/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.HandleDelta;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.util.TextRange;

public class SourceElementBody
extends Body
implements ISourceElementInfo {
    private static final Property[] NO_PROPERTIES = new Property[0];
    private ISnapshot snapshot;
    private Property[] properties = NO_PROPERTIES;
    private TextRange fullRange;
    private TextRange identifyingRange;

    @Override
    public ISourceConstruct[] getChildren() {
        IHandle[] children = super.getChildren();
        int length = children.length;
        ISourceConstruct[] result = new ISourceConstruct[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    @Override
    public <T> T get(ISourceElement.Property<T> p) {
        return (T)this.getPropertyValue(p.getName());
    }

    @Override
    public ISnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public TextRange getFullRange() {
        return this.fullRange;
    }

    @Override
    public TextRange getIdentifyingRange() {
        return this.identifyingRange;
    }

    public <T> void set(ISourceElement.Property<T> p, T value) {
        String name = p.getName();
        int len = this.properties.length;
        if (len == 0) {
            this.properties = new Property[]{new Property(name, value)};
        } else {
            int i = 0;
            while (i < len) {
                if (this.properties[i].name.equals(name)) {
                    this.properties[i].value = value;
                    return;
                }
                ++i;
            }
            Property[] newProperties = new Property[len + 1];
            System.arraycopy(this.properties, 0, newProperties, 0, len);
            newProperties[len] = new Property(name, value);
            this.properties = newProperties;
        }
    }

    public void setSnapshot(ISnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public void setFullRange(TextRange fullRange) {
        this.fullRange = fullRange;
    }

    public void setIdentifyingRange(TextRange identifyingRange) {
        this.identifyingRange = identifyingRange;
    }

    @Override
    public void findContentChange(Body oldBody, IHandle element, HandleDelta delta) {
        Set<String> newPropertyNames = this.getPropertyNames();
        Set<String> oldPropertyNames = ((SourceElementBody)oldBody).getPropertyNames();
        HashSet<String> combinedPropertyNames = new HashSet<String>(newPropertyNames.size() + oldPropertyNames.size());
        combinedPropertyNames.addAll(newPropertyNames);
        combinedPropertyNames.addAll(oldPropertyNames);
        for (String propertyName : combinedPropertyNames) {
            Object oldValue;
            Object newValue;
            if (!this.isPropertyChanged(propertyName, newValue = this.getPropertyValue(propertyName), oldValue = ((SourceElementBody)oldBody).getPropertyValue(propertyName))) continue;
            delta.insertChanged(element, 1);
            return;
        }
    }

    protected boolean isPropertyChanged(String propertyName, Object newValue, Object oldValue) {
        boolean eq;
        return newValue == null ? oldValue != null : !(eq = newValue instanceof Object[] && oldValue instanceof Object[] ? Arrays.deepEquals((Object[])newValue, (Object[])oldValue) : (newValue instanceof byte[] && oldValue instanceof byte[] ? Arrays.equals((byte[])newValue, (byte[])oldValue) : (newValue instanceof short[] && oldValue instanceof short[] ? Arrays.equals((short[])newValue, (short[])oldValue) : (newValue instanceof int[] && oldValue instanceof int[] ? Arrays.equals((int[])newValue, (int[])oldValue) : (newValue instanceof long[] && oldValue instanceof long[] ? Arrays.equals((long[])newValue, (long[])oldValue) : (newValue instanceof char[] && oldValue instanceof char[] ? Arrays.equals((char[])newValue, (char[])oldValue) : (newValue instanceof float[] && oldValue instanceof float[] ? Arrays.equals((float[])newValue, (float[])oldValue) : (newValue instanceof double[] && oldValue instanceof double[] ? Arrays.equals((double[])newValue, (double[])oldValue) : (newValue instanceof boolean[] && oldValue instanceof boolean[] ? Arrays.equals((boolean[])newValue, (boolean[])oldValue) : newValue.equals(oldValue))))))))));
    }

    protected final Object getPropertyValue(String propertyName) {
        int length = this.properties.length;
        int i = 0;
        while (i < length) {
            Property property = this.properties[i];
            if (property.name.equals(propertyName)) {
                return property.value;
            }
            ++i;
        }
        return null;
    }

    protected final Set<String> getPropertyNames() {
        int length = this.properties.length;
        HashSet<String> names = new HashSet<String>(length);
        int i = 0;
        while (i < length) {
            names.add(this.properties[i].name);
            ++i;
        }
        return names;
    }

    private static class Property {
        public final String name;
        public Object value;

        public Property(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

