/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.IHandleDelta;
import org.eclipse.handly.model.impl.HandleDelta;

public class FooModelNotificationTest
extends WorkspaceTestCase {
    private IFooModel fooModel = FooModelCore.getFooModel();
    private FooModelListener listener = new FooModelListener();

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpProject("Test001");
        this.fooModel.addElementChangeListener((IElementChangeListener)this.listener);
    }

    protected void tearDown() throws Exception {
        this.fooModel.removeElementChangeListener((IElementChangeListener)this.listener);
        super.tearDown();
    }

    public void testFooModelNotification() throws Exception {
        IFooProject fooProject1 = this.fooModel.getFooProject("Test001");
        IFooProject fooProject2 = this.fooModel.getFooProject("Test002");
        this.setUpProject("Test002");
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertAdded((IHandle)fooProject2), (IHandleDelta)this.listener.delta);
        IFooFile fooFile1 = fooProject1.getFooFile("test.foo");
        fooFile1.getFile().touch(null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertChanged((IHandle)fooFile1, 1), (IHandleDelta)this.listener.delta);
        fooFile1.getFile().copy((IPath)new Path("/Test002/test1.foo"), true, null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertAdded((IHandle)fooProject2.getFooFile("test1.foo")), (IHandleDelta)this.listener.delta);
        fooFile1.getFile().delete(true, null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertRemoved((IHandle)fooFile1), (IHandleDelta)this.listener.delta);
        IFooFile fooFile2 = fooProject2.getFooFile("test.foo");
        IFooFile movedFooFile2 = fooProject1.getFooFile("test1.foo");
        fooFile2.getFile().move((IPath)new Path("/Test001/test1.foo"), true, null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertMovedTo((IHandle)movedFooFile2, (IHandle)fooFile2).insertMovedFrom((IHandle)fooFile2, (IHandle)movedFooFile2), (IHandleDelta)this.listener.delta);
        IFolder aFolder = fooProject1.getProject().getFolder("a");
        aFolder.delete(true, null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertChanged((IHandle)fooProject1, 1), (IHandleDelta)this.listener.delta);
        FooModelNotificationTest.assertEquals((int)0, (int)this.listener.delta.getResourceDeltas().length);
        HandleDelta projectDelta = this.listener.delta.getDeltaFor((IHandle)fooProject1);
        FooModelNotificationTest.assertEquals((int)1, (int)projectDelta.getResourceDeltas().length);
        IResourceDelta resourceDelta = projectDelta.getResourceDeltas()[0];
        FooModelNotificationTest.assertEquals((int)2, (int)resourceDelta.getKind());
        FooModelNotificationTest.assertEquals((Object)aFolder, (Object)resourceDelta.getResource());
        IFile bFile = fooProject1.getProject().getFile("b");
        bFile.touch(null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertChanged((IHandle)fooProject1, 1), (IHandleDelta)this.listener.delta);
        FooModelNotificationTest.assertEquals((int)0, (int)this.listener.delta.getResourceDeltas().length);
        projectDelta = this.listener.delta.getDeltaFor((IHandle)fooProject1);
        FooModelNotificationTest.assertEquals((int)1, (int)projectDelta.getResourceDeltas().length);
        resourceDelta = projectDelta.getResourceDeltas()[0];
        FooModelNotificationTest.assertEquals((int)4, (int)resourceDelta.getKind());
        FooModelNotificationTest.assertEquals((Object)bFile, (Object)resourceDelta.getResource());
        IProject simpleProject = this.setUpProject("SimpleProject");
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertChanged((IHandle)this.fooModel, 1), (IHandleDelta)this.listener.delta);
        FooModelNotificationTest.assertEquals((int)1, (int)this.listener.delta.getResourceDeltas().length);
        resourceDelta = this.listener.delta.getResourceDeltas()[0];
        FooModelNotificationTest.assertEquals((int)1, (int)resourceDelta.getKind());
        FooModelNotificationTest.assertEquals((Object)simpleProject, (Object)resourceDelta.getResource());
        fooProject2.getProject().close(null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertRemoved((IHandle)fooProject2, 64), (IHandleDelta)this.listener.delta);
        fooProject2.getProject().open(null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertAdded((IHandle)fooProject2, 64), (IHandleDelta)this.listener.delta);
        fooProject2.getProject().delete(true, null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertRemoved((IHandle)fooProject2), (IHandleDelta)this.listener.delta);
        IProjectDescription description = fooProject1.getProject().getDescription();
        String[] oldNatures = description.getNatureIds();
        description.setNatureIds(new String[0]);
        fooProject1.getProject().setDescription(description, null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertRemoved((IHandle)fooProject1, 128), (IHandleDelta)this.listener.delta);
        description.setNatureIds(oldNatures);
        fooProject1.getProject().setDescription(description, null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertAdded((IHandle)fooProject1, 128), (IHandleDelta)this.listener.delta);
        IFooProject movedFooProject1 = this.fooModel.getFooProject("Test");
        fooProject1.getProject().move((IPath)new Path("Test"), true, null);
        FooModelNotificationTest.assertDelta((IHandleDelta)this.newDelta().insertMovedTo((IHandle)movedFooProject1, (IHandle)fooProject1).insertMovedFrom((IHandle)fooProject1, (IHandle)movedFooProject1), (IHandleDelta)this.listener.delta);
    }

    private HandleDelta newDelta() {
        return new HandleDelta((IHandle)this.fooModel);
    }

    private static void assertDelta(IHandleDelta expected, IHandleDelta actual) {
        if (expected == null) {
            FooModelNotificationTest.assertNull((Object)actual);
            return;
        }
        FooModelNotificationTest.assertNotNull((Object)actual);
        FooModelNotificationTest.assertEquals((Object)expected.getElement(), (Object)actual.getElement());
        FooModelNotificationTest.assertEquals((int)expected.getKind(), (int)actual.getKind());
        FooModelNotificationTest.assertEquals((int)expected.getFlags(), (int)actual.getFlags());
        FooModelNotificationTest.assertEquals((Object)expected.getMovedToElement(), (Object)actual.getMovedToElement());
        FooModelNotificationTest.assertEquals((Object)expected.getMovedFromElement(), (Object)actual.getMovedFromElement());
        IHandleDelta[] expectedChildren = expected.getAffectedChildren();
        IHandleDelta[] actualChildren = actual.getAffectedChildren();
        FooModelNotificationTest.assertEquals((int)expectedChildren.length, (int)actualChildren.length);
        int i = 0;
        while (i < expectedChildren.length) {
            FooModelNotificationTest.assertDelta(expectedChildren[i], actualChildren[i]);
            ++i;
        }
    }

    private static class FooModelListener
    implements IElementChangeListener {
        public HandleDelta delta;

        private FooModelListener() {
        }

        public void elementChanged(IElementChangeEvent event) {
            this.delta = (HandleDelta)event.getDelta();
        }
    }
}

