/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import junit.framework.TestCase;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.internal.examples.basic.ui.model.FooFile;

public class FooProjectTest
extends TestCase {
    private IFooProject fooProject;

    protected void setUp() throws Exception {
        super.setUp();
        this.fooProject = FooModelCore.getFooModel().getFooProject("test");
    }

    protected void tearDown() throws Exception {
        if (this.fooProject != null) {
            this.fooProject.getProject().delete(true, null);
        }
        super.tearDown();
    }

    public void testHandleOnly() {
        FooProjectTest.assertEquals((String)"test", (String)this.fooProject.getName());
        FooProjectTest.assertEquals((Object)ResourcesPlugin.getWorkspace().getRoot().getProject("test"), (Object)this.fooProject.getProject());
        IFooFile fooFile = this.fooProject.getFooFile("test.foo");
        FooProjectTest.assertNotNull((Object)fooFile);
        FooProjectTest.assertEquals((String)"test.foo", (String)fooFile.getName());
        FooProjectTest.assertEquals(FooFile.class, fooFile.getClass());
    }

    public void testProjectCreation() throws Exception {
        this.fooProject.create(null);
        IProject project = this.fooProject.getProject();
        FooProjectTest.assertTrue((boolean)project.exists());
        FooProjectTest.assertTrue((boolean)project.isOpen());
        IProjectDescription description = project.getDescription();
        String[] natureIds = description.getNatureIds();
        FooProjectTest.assertEquals((int)2, (int)natureIds.length);
        FooProjectTest.assertEquals((String)"org.eclipse.xtext.ui.shared.xtextNature", (String)natureIds[0]);
        FooProjectTest.assertEquals((String)"org.eclipse.handly.examples.basic.ui.fooNature", (String)natureIds[1]);
        FooProjectTest.assertEquals((String)"UTF-8", (String)project.getDefaultCharset());
        ICommand[] buildSpec = description.getBuildSpec();
        FooProjectTest.assertEquals((int)1, (int)buildSpec.length);
        FooProjectTest.assertEquals((String)"org.eclipse.xtext.ui.shared.xtextBuilder", (String)buildSpec[0].getBuilderName());
    }
}

