/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.handly.examples.basic.foo.Module;
import org.eclipse.handly.examples.basic.ui.model.IFooDef;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.examples.basic.ui.model.IFooVar;
import org.eclipse.handly.internal.examples.basic.ui.Activator;
import org.eclipse.handly.internal.examples.basic.ui.model.FooDef;
import org.eclipse.handly.internal.examples.basic.ui.model.FooFileStructureBuilder;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModelManager;
import org.eclipse.handly.internal.examples.basic.ui.model.FooProject;
import org.eclipse.handly.internal.examples.basic.ui.model.FooVar;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.IHandleDelta;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.ElementChangeEvent;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.HandleDelta;
import org.eclipse.handly.model.impl.HandleDeltaBuilder;
import org.eclipse.handly.model.impl.HandleManager;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class FooFile
extends SourceFile
implements IFooFile {
    public FooFile(FooProject parent, IFile file) {
        super((Handle)parent, file);
        if (!file.getParent().equals((Object)parent.getProject())) {
            throw new IllegalArgumentException();
        }
        if (!"foo".equals(file.getFileExtension())) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public FooProject getParent() {
        return (FooProject)this.parent;
    }

    @Override
    public IFooModel getRoot() {
        return (IFooModel)super.getRoot();
    }

    @Override
    public IFooVar getVar(String name) {
        return new FooVar(this, name);
    }

    @Override
    public IFooVar[] getVars() throws CoreException {
        return (IFooVar[])this.getChildren(IFooVar.class);
    }

    @Override
    public IFooDef getDef(String name, int arity) {
        return new FooDef(this, name, arity);
    }

    @Override
    public IFooDef[] getDefs() throws CoreException {
        return (IFooDef[])this.getChildren(IFooDef.class);
    }

    public SourceFile.ReconcileOperation getReconcileOperation() {
        return new NotifyingReconcileOperation();
    }

    protected void buildStructure(SourceElementBody body, Map<IHandle, Body> newElements, Object ast, String source) {
        EObject root;
        XtextResource resource = (XtextResource)ast;
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && (root = parseResult.getRootASTElement()) instanceof Module) {
            FooFileStructureBuilder builder = new FooFileStructureBuilder(newElements, resource.getResourceServiceProvider());
            builder.buildStructure(this, body, (Module)root);
        }
    }

    protected XtextResource createStructuralAst(String source) throws CoreException {
        try {
            return this.parse(source, this.getFile().getCharset());
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    protected XtextResource parse(String contents, String encoding) throws IOException {
        IResourceSetProvider resourceSetProvider = (IResourceSetProvider)this.getResourceServiceProvider().get(IResourceSetProvider.class);
        ResourceSet resourceSet = resourceSetProvider.get(this.getFile().getProject());
        XtextResource resource = (XtextResource)resourceSet.createResource(this.getResourceUri());
        resource.load((InputStream)new ByteArrayInputStream(contents.getBytes(encoding)), Collections.singletonMap(XtextResource.OPTION_ENCODING, encoding));
        return resource;
    }

    protected IResourceServiceProvider getResourceServiceProvider() {
        IResourceServiceProvider provider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(this.getResourceUri());
        if (provider == null) {
            throw new AssertionError();
        }
        return provider;
    }

    protected URI getResourceUri() {
        return URI.createPlatformResourceURI((String)this.getPath().toString(), (boolean)true);
    }

    protected HandleManager getHandleManager() {
        return FooModelManager.INSTANCE.getHandleManager();
    }

    protected void workingCopyModeChanged() {
        super.workingCopyModeChanged();
        HandleDelta delta = new HandleDelta((IHandle)this.getRoot());
        if (this.file.exists()) {
            delta.insertChanged((IHandle)this, 256);
        } else {
            delta.insertAdded((IHandle)this, 256);
        }
        FooModelManager.INSTANCE.fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(1, (IHandleDelta)delta));
    }

    private class NotifyingReconcileOperation
    extends SourceFile.ReconcileOperation {
        private NotifyingReconcileOperation() {
            super((SourceFile)FooFile.this);
        }

        public void reconcile(Object ast, NonExpiringSnapshot snapshot, boolean forced) throws CoreException {
            HandleDeltaBuilder deltaBuilder = new HandleDeltaBuilder((IHandle)FooFile.this);
            super.reconcile(ast, snapshot, forced);
            deltaBuilder.buildDelta();
            if (!deltaBuilder.getDelta().isEmpty()) {
                FooModelManager.INSTANCE.fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(2, (IHandleDelta)deltaBuilder.getDelta()));
            }
        }
    }
}

