/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IImportContainer;
import org.eclipse.handly.examples.javamodel.IImportDeclaration;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.examples.javamodel.IPackageDeclaration;
import org.eclipse.handly.examples.javamodel.IType;
import org.eclipse.handly.internal.examples.javamodel.CompilatonUnitStructureBuilder;
import org.eclipse.handly.internal.examples.javamodel.ImportContainer;
import org.eclipse.handly.internal.examples.javamodel.JavaElementDelta;
import org.eclipse.handly.internal.examples.javamodel.JavaElementDeltaBuilder;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.handly.internal.examples.javamodel.PackageDeclaration;
import org.eclipse.handly.internal.examples.javamodel.PackageFragment;
import org.eclipse.handly.internal.examples.javamodel.Type;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.IHandleDelta;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.ElementChangeEvent;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.HandleManager;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.dom.ASTParser;

public class CompilationUnit
extends SourceFile
implements ICompilationUnit {
    private static final IImportDeclaration[] NO_IMPORTS = new IImportDeclaration[0];

    public CompilationUnit(PackageFragment parent, IFile file) {
        super((Handle)parent, file);
        if (!file.getParent().equals((Object)parent.getResource())) {
            throw new IllegalArgumentException();
        }
        if (!"java".equals(file.getFileExtension())) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public PackageFragment getParent() {
        return (PackageFragment)this.parent;
    }

    @Override
    public IJavaModel getRoot() {
        return (IJavaModel)super.getRoot();
    }

    @Override
    public IImportDeclaration getImport(String name) {
        return this.getImportContainer().getImport(name);
    }

    @Override
    public IImportContainer getImportContainer() {
        return new ImportContainer(this);
    }

    @Override
    public IImportDeclaration[] getImports() throws CoreException {
        IImportContainer container = this.getImportContainer();
        if (container.exists()) {
            return container.getImports();
        }
        return NO_IMPORTS;
    }

    @Override
    public IPackageDeclaration getPackageDeclaration(String name) {
        return new PackageDeclaration(this, name);
    }

    @Override
    public IPackageDeclaration[] getPackageDeclarations() throws CoreException {
        return (IPackageDeclaration[])this.getChildren(IPackageDeclaration.class);
    }

    @Override
    public IType getType(String name) {
        return new Type((Handle)this, name);
    }

    @Override
    public IType[] getTypes() throws CoreException {
        return (IType[])this.getChildren(IType.class);
    }

    public SourceFile.ReconcileOperation getReconcileOperation() {
        return new NotifyingReconcileOperation();
    }

    protected HandleManager getHandleManager() {
        return JavaModelManager.INSTANCE.getHandleManager();
    }

    protected void validateExistence() throws CoreException {
        super.validateExistence();
        IStatus status = this.validateCompilationUnitName();
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
    }

    IStatus validateCompilationUnitName() {
        JavaProject javaProject = (JavaProject)this.getAncestor(JavaProject.class);
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validateCompilationUnitName((String)this.name, (String)sourceLevel, (String)complianceLevel);
    }

    protected Object createStructuralAst(String source) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setSource(source.toCharArray());
        parser.setFocalPosition(0);
        JavaProject javaProject = (JavaProject)this.getAncestor(JavaProject.class);
        Map<String, String> options = javaProject.getOptions(true);
        parser.setCompilerOptions(options);
        return parser.createAST(null);
    }

    protected void buildStructure(SourceElementBody body, Map<IHandle, Body> newElements, Object ast, String source) {
        CompilatonUnitStructureBuilder builder = new CompilatonUnitStructureBuilder(newElements);
        builder.buildStructure(this, body, (org.eclipse.jdt.core.dom.CompilationUnit)ast);
    }

    protected void workingCopyModeChanged() {
        super.workingCopyModeChanged();
        JavaElementDelta delta = new JavaElementDelta(this.getRoot());
        if (this.file.exists()) {
            delta.insertChanged(this, 256);
        } else {
            delta.insertAdded(this, 256);
        }
        JavaModelManager.INSTANCE.fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(1, (IHandleDelta)delta));
    }

    private class NotifyingReconcileOperation
    extends SourceFile.ReconcileOperation {
        private NotifyingReconcileOperation() {
            super((SourceFile)CompilationUnit.this);
        }

        public void reconcile(Object ast, NonExpiringSnapshot snapshot, boolean forced) throws CoreException {
            JavaElementDeltaBuilder deltaBuilder = new JavaElementDeltaBuilder(CompilationUnit.this);
            super.reconcile(ast, snapshot, forced);
            deltaBuilder.buildDelta();
            JavaElementDelta delta = deltaBuilder.getDelta();
            if (!delta.isEmpty()) {
                JavaModelManager.INSTANCE.fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(2, (IHandleDelta)delta));
            }
        }
    }
}

