/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.examples.javamodel.IJavaProject;
import org.eclipse.handly.examples.javamodel.IPackageFragment;
import org.eclipse.handly.examples.javamodel.IPackageFragmentRoot;
import org.eclipse.handly.internal.examples.javamodel.CompilationUnit;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.jdt.core.IClasspathEntry;

class DeltaProcessingState {
    private Map<JavaProject, ClasspathInfo> classpaths;
    private Map<JavaProject, ClasspathInfo> oldClasspaths;
    private Set<String> oldJavaProjectNames;

    DeltaProcessingState() {
    }

    void initialize() {
        IJavaProject[] javaProjects;
        this.classpaths = new HashMap<JavaProject, ClasspathInfo>();
        try {
            javaProjects = this.getJavaModel().getJavaProjects();
        }
        catch (CoreException e) {
            return;
        }
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IPath outputLocation;
                IClasspathEntry[] classpath;
                IJavaProject each = iJavaProjectArray[n2];
                JavaProject javaProject = (JavaProject)each;
                try {
                    classpath = javaProject.getRawClasspath();
                    outputLocation = javaProject.getOutputLocation();
                }
                catch (CoreException e) {
                    break block5;
                }
                this.classpaths.put(javaProject, new ClasspathInfo(classpath, outputLocation));
            }
            ++n2;
        }
    }

    void reset() {
        this.oldClasspaths = null;
        this.oldJavaProjectNames = null;
    }

    void initOldClasspathInfo() {
        this.oldClasspaths = new HashMap<JavaProject, ClasspathInfo>(this.classpaths);
    }

    void initOldJavaProjectNames() {
        IJavaProject[] javaProjects;
        try {
            javaProjects = this.getJavaModel().getJavaProjects();
        }
        catch (CoreException e) {
            return;
        }
        HashSet<String> javaProjectNames = new HashSet<String>(javaProjects.length);
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            javaProjectNames.add(javaProject.getName());
            ++n2;
        }
        this.oldJavaProjectNames = javaProjectNames;
    }

    Set<String> getOldJavaProjectNames() {
        return this.oldJavaProjectNames;
    }

    boolean classpathChanged(JavaProject javaProject, boolean remove) {
        IPath outputLocation;
        IClasspathEntry[] classpath;
        if (remove) {
            this.classpaths.remove(javaProject);
            return true;
        }
        javaProject.resetRawClasspath();
        try {
            classpath = javaProject.getRawClasspath();
            outputLocation = javaProject.getOutputLocation();
        }
        catch (CoreException e) {
            return true;
        }
        ClasspathInfo classpathInfo = new ClasspathInfo(classpath, outputLocation);
        ClasspathInfo oldClasspathInfo = this.classpaths.put(javaProject, classpathInfo);
        return !classpathInfo.isEqualTo(oldClasspathInfo);
    }

    IJavaElement createElement(IResource resource, boolean oldState) {
        if (resource instanceof IProject) {
            return this.createElement((IProject)resource, oldState);
        }
        if (resource instanceof IFolder) {
            return this.createElement((IFolder)resource, oldState);
        }
        if (resource instanceof IFile) {
            return this.createElement((IFile)resource, oldState);
        }
        if (resource instanceof IWorkspaceRoot) {
            return this.getJavaModel();
        }
        throw new IllegalArgumentException();
    }

    IJavaProject createElement(IProject project, boolean oldState) {
        String name = project.getName();
        if (oldState) {
            if (!this.oldJavaProjectNames.contains(name)) {
                return null;
            }
        } else {
            try {
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return null;
                }
            }
            catch (CoreException e) {
                return null;
            }
        }
        return this.getJavaModel().getJavaProject(name);
    }

    IJavaElement createElement(IFolder folder, boolean oldState) {
        JavaProject javaProject = (JavaProject)this.createElement(folder.getProject(), oldState);
        if (javaProject == null) {
            return null;
        }
        ClasspathInfo classpathInfo = oldState ? this.oldClasspaths.get(javaProject) : this.classpaths.get(javaProject);
        if (classpathInfo == null) {
            return null;
        }
        IPackageFragment pkg = javaProject.findPackageFragment((IResource)folder, classpathInfo.classpath);
        if (pkg != null && pkg.isDefaultPackage()) {
            return pkg.getParent();
        }
        return pkg;
    }

    IJavaElement createElement(IFile file, boolean oldState) {
        if ("java".equals(file.getFileExtension())) {
            return this.createCompilationUnitFrom(file, oldState);
        }
        return null;
    }

    ICompilationUnit createCompilationUnitFrom(IFile file, boolean oldState) {
        IContainer parent = file.getParent();
        if (!(parent instanceof IFolder)) {
            return null;
        }
        IJavaElement element = this.createElement((IFolder)parent, oldState);
        if (element == null) {
            return null;
        }
        IPackageFragment pkg = element instanceof IPackageFragment ? (IPackageFragment)element : ((IPackageFragmentRoot)element).getPackageFragment("");
        CompilationUnit cu = (CompilationUnit)pkg.getCompilationUnit(file.getName());
        if (cu.validateCompilationUnitName().getSeverity() == 4) {
            return null;
        }
        return cu;
    }

    IJavaModel getJavaModel() {
        return JavaModelManager.INSTANCE.getJavaModel();
    }

    private static class ClasspathInfo {
        final IClasspathEntry[] classpath;
        final IPath outputLocation;

        ClasspathInfo(IClasspathEntry[] classpath, IPath outputLocation) {
            if (classpath == null) {
                throw new IllegalArgumentException();
            }
            if (outputLocation == null) {
                throw new IllegalArgumentException();
            }
            this.classpath = classpath;
            this.outputLocation = outputLocation;
        }

        boolean isEqualTo(ClasspathInfo other) {
            if (other == null) {
                return false;
            }
            return Arrays.equals(this.classpath, other.classpath) && this.outputLocation.equals((Object)other.outputLocation);
        }
    }
}

