/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.javamodel.IImportContainer;
import org.eclipse.handly.examples.javamodel.IImportDeclaration;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.internal.examples.javamodel.CompilationUnit;
import org.eclipse.handly.internal.examples.javamodel.ImportDeclaration;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.HandleManager;
import org.eclipse.handly.model.impl.SourceConstruct;

public class ImportContainer
extends SourceConstruct
implements IImportContainer {
    public ImportContainer(CompilationUnit parent) {
        super((Handle)parent, null);
    }

    @Override
    public CompilationUnit getParent() {
        return (CompilationUnit)this.parent;
    }

    @Override
    public IJavaModel getRoot() {
        return (IJavaModel)super.getRoot();
    }

    @Override
    public IImportDeclaration getImport(String name) {
        return new ImportDeclaration(this, name);
    }

    @Override
    public IImportDeclaration[] getImports() throws CoreException {
        IHandle[] children = this.getChildren();
        int length = children.length;
        IImportDeclaration[] result = new IImportDeclaration[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    protected HandleManager getHandleManager() {
        return JavaModelManager.INSTANCE.getHandleManager();
    }

    protected void toStringName(StringBuilder builder) {
        builder.append("<import container>");
    }

    protected void toString(int tab, StringBuilder builder) {
        Body body = this.peekAtBody();
        if (body == null) {
            return;
        }
        IHandle[] children = body.getChildren();
        int i = 0;
        while (i < children.length) {
            if (i > 0) {
                builder.append('\n');
            }
            ((Handle)children[i]).toStringBody(tab, builder);
            ++i;
        }
    }
}

