/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.examples.javamodel.IJavaProject;
import org.eclipse.handly.internal.examples.javamodel.JavaModelBody;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.HandleManager;

public class JavaModel
extends Handle
implements IJavaModel {
    private final IWorkspace workspace;

    public JavaModel(IWorkspace workspace) {
        super(null, null);
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
    }

    @Override
    public IJavaElement getParent() {
        return null;
    }

    @Override
    public IJavaModel getRoot() {
        return this;
    }

    @Override
    public void addElementChangeListener(IElementChangeListener listener) {
        JavaModelManager.INSTANCE.addElementChangeListener(listener);
    }

    @Override
    public void removeElementChangeListener(IElementChangeListener listener) {
        JavaModelManager.INSTANCE.removeElementChangeListener(listener);
    }

    @Override
    public IJavaProject getJavaProject(String name) {
        return new JavaProject(this, this.workspace.getRoot().getProject(name));
    }

    @Override
    public IJavaProject[] getJavaProjects() throws CoreException {
        IHandle[] children = this.getChildren();
        int length = children.length;
        IJavaProject[] result = new IJavaProject[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    @Override
    public IProject[] getNonJavaProjects() throws CoreException {
        return ((JavaModelBody)this.getBody()).getNonJavaProjects(this);
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public IResource getResource() {
        return this.workspace.getRoot();
    }

    public boolean exists() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaModel other = (JavaModel)obj;
        return this.workspace.equals(other.workspace);
    }

    public int hashCode() {
        return this.workspace.hashCode();
    }

    protected HandleManager getHandleManager() {
        return JavaModelManager.INSTANCE.getHandleManager();
    }

    protected void validateExistence() throws CoreException {
    }

    protected void buildStructure(Body body, Map<IHandle, Body> newElements) throws CoreException {
        IProject[] projects = this.workspace.getRoot().getProjects();
        ArrayList<JavaProject> javaProjects = new ArrayList<JavaProject>(projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProjects.add(new JavaProject(this, project));
            }
            ++n2;
        }
        body.setChildren(javaProjects.toArray(new IHandle[javaProjects.size()]));
    }

    protected Body newBody() {
        return new JavaModelBody();
    }

    protected void toStringName(StringBuilder builder) {
        builder.append("Java Model");
    }
}

