/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.internal.examples.javamodel.Activator;
import org.eclipse.handly.internal.examples.javamodel.DeltaProcessingState;
import org.eclipse.handly.internal.examples.javamodel.DeltaProcessor;
import org.eclipse.handly.internal.examples.javamodel.JavaElementDelta;
import org.eclipse.handly.internal.examples.javamodel.JavaModel;
import org.eclipse.handly.internal.examples.javamodel.JavaModelCache;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.handly.internal.examples.javamodel.PerProjectInfo;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IHandleDelta;
import org.eclipse.handly.model.impl.ElementChangeEvent;
import org.eclipse.handly.model.impl.HandleManager;
import org.eclipse.handly.model.impl.IBodyCache;

public class JavaModelManager
implements IResourceChangeListener {
    public static final JavaModelManager INSTANCE = new JavaModelManager();
    private JavaModel javaModel;
    private HandleManager handleManager;
    private ListenerList listenerList;
    private DeltaProcessingState deltaState;
    private Map<IProject, PerProjectInfo> perProjectInfo = new HashMap<IProject, PerProjectInfo>(5);

    public void startup() throws Exception {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.javaModel = new JavaModel(workspace);
            this.handleManager = new HandleManager((IBodyCache)new JavaModelCache());
            this.listenerList = new ListenerList();
            this.deltaState = new DeltaProcessingState();
            this.deltaState.initialize();
            workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            new SavedStateJob().schedule();
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.deltaState = null;
        this.listenerList = null;
        this.handleManager = null;
        this.javaModel = null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        DeltaProcessor deltaProcessor;
        block7: {
            if (event.getType() != 1) {
                return;
            }
            deltaProcessor = new DeltaProcessor(this.deltaState);
            try {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)deltaProcessor);
                }
                catch (CoreException e) {
                    Activator.log(e.getStatus());
                    this.deltaState.reset();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.deltaState.reset();
                throw throwable;
            }
            this.deltaState.reset();
        }
        JavaElementDelta delta = deltaProcessor.getDelta();
        if (!delta.isEmpty()) {
            this.fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(1, (IHandleDelta)delta));
        }
    }

    public IJavaModel getJavaModel() {
        if (this.javaModel == null) {
            throw new IllegalStateException();
        }
        return this.javaModel;
    }

    public HandleManager getHandleManager() {
        if (this.handleManager == null) {
            throw new IllegalStateException();
        }
        return this.handleManager;
    }

    public void addElementChangeListener(IElementChangeListener listener) {
        if (this.listenerList == null) {
            throw new IllegalStateException();
        }
        this.listenerList.add((Object)listener);
    }

    public void removeElementChangeListener(IElementChangeListener listener) {
        if (this.listenerList == null) {
            throw new IllegalStateException();
        }
        this.listenerList.remove((Object)listener);
    }

    public void fireElementChangeEvent(final IElementChangeEvent event) {
        Object[] listeners;
        if (this.listenerList == null) {
            throw new IllegalStateException();
        }
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    ((IElementChangeListener)listener).elementChanged(event);
                }
            });
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfo;
        synchronized (map) {
            PerProjectInfo info = this.perProjectInfo.get(project);
            if (info == null && create) {
                info = new PerProjectInfo(project);
                this.perProjectInfo.put(project, info);
            }
            return info;
        }
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject project) throws CoreException {
        PerProjectInfo info = this.getPerProjectInfo(project, false);
        if (info == null) {
            new JavaProject(this.javaModel, project).validateExistence();
            info = this.getPerProjectInfo(project, true);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerProjectInfo(IProject project) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfo;
        synchronized (map) {
            this.perProjectInfo.remove(project);
        }
    }

    private JavaModelManager() {
    }

    private static class SavedStateJob
    extends WorkspaceJob {
        public SavedStateJob() {
            super("SavedState");
            this.setSystem(true);
            this.setPriority(20);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            ISavedState savedState = ResourcesPlugin.getWorkspace().addSaveParticipant("org.eclipse.handly.examples.javamodel", (ISaveParticipant)new SaveParticipant());
            if (savedState != null) {
                savedState.processResourceChangeEvents((IResourceChangeListener)INSTANCE);
            }
            return Status.OK_STATUS;
        }

        private static class SaveParticipant
        implements ISaveParticipant {
            private SaveParticipant() {
            }

            public void doneSaving(ISaveContext context) {
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void rollback(ISaveContext context) {
            }

            public void saving(ISaveContext context) throws CoreException {
                if (context.getKind() == 1) {
                    context.needDelta();
                }
            }
        }
    }
}

