/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.examples.javamodel.IJavaProject;
import org.eclipse.handly.examples.javamodel.IPackageFragment;
import org.eclipse.handly.examples.javamodel.IPackageFragmentRoot;
import org.eclipse.handly.internal.examples.javamodel.Activator;
import org.eclipse.handly.internal.examples.javamodel.JavaModel;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.internal.examples.javamodel.JavaProjectBody;
import org.eclipse.handly.internal.examples.javamodel.PackageFragment;
import org.eclipse.handly.internal.examples.javamodel.PackageFragmentRoot;
import org.eclipse.handly.internal.examples.javamodel.PerProjectInfo;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.HandleManager;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public class JavaProject
extends Handle
implements IJavaProject {
    private final IProject project;

    public JavaProject(JavaModel parent, IProject project) {
        super((Handle)parent, project.getName());
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.project = project;
    }

    @Override
    public JavaModel getParent() {
        return (JavaModel)this.parent;
    }

    @Override
    public IJavaModel getRoot() {
        return (IJavaModel)super.getRoot();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public IResource getResource() {
        return this.project;
    }

    @Override
    public PackageFragmentRoot getPackageFragmentRoot(IResource resource) {
        if (resource != null && resource.getType() == 2 && resource.getParent().equals((Object)this.project)) {
            return new PackageFragmentRoot(this, resource);
        }
        return null;
    }

    @Override
    public IPackageFragmentRoot[] getPackageFragmentRoots() throws CoreException {
        IHandle[] children = this.getChildren();
        int length = children.length;
        IPackageFragmentRoot[] result = new IPackageFragmentRoot[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    @Override
    public IResource[] getNonJavaResources() throws CoreException {
        return ((JavaProjectBody)this.getBody()).getNonJavaResources(this);
    }

    @Override
    public IPackageFragment findPackageFragment(IResource resource) {
        if (!this.exists()) {
            return null;
        }
        try {
            IClasspathEntry[] rawClasspath = this.getRawClasspath();
            return this.findPackageFragment(resource, rawClasspath);
        }
        catch (CoreException e) {
            return null;
        }
    }

    IPackageFragment findPackageFragment(IResource resource, IClasspathEntry[] classpath) {
        if (resource.getType() != 2) {
            return null;
        }
        IPath resourcePath = resource.getFullPath();
        IClasspathEntry[] iClasspathEntryArray = classpath;
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            int entryKind = entry.getEntryKind();
            if (entryKind == 3) {
                IPath entryPath = entry.getPath();
                if (entryPath.equals((Object)resourcePath)) {
                    PackageFragmentRoot root = this.getPackageFragmentRoot(resource);
                    if (root == null) {
                        return null;
                    }
                    return root.getPackageFragment("");
                }
                if (entryPath.isPrefixOf(resourcePath)) {
                    Object rootFolder = entryPath.segmentCount() == 1 ? this.project : this.project.getParent().getFolder(entryPath);
                    PackageFragmentRoot root = this.getPackageFragmentRoot((IResource)rootFolder);
                    if (root == null) {
                        return null;
                    }
                    IPath packagePath = resourcePath.removeFirstSegments(entryPath.segmentCount());
                    PackageFragment packageFragment = root.getPackageFragment(packagePath.segments());
                    if (!packageFragment.isValidPackageName()) {
                        return null;
                    }
                    return packageFragment;
                }
            }
            ++n2;
        }
        return null;
    }

    protected HandleManager getHandleManager() {
        return JavaModelManager.INSTANCE.getHandleManager();
    }

    protected void validateExistence() throws CoreException {
        if (!this.project.exists()) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format("Project ''{0}'' does not exist in workspace", this.name), null));
        }
        if (!this.project.isOpen()) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format("Project ''{0}'' is not open", this.name), null));
        }
        if (!this.project.hasNature("org.eclipse.jdt.core.javanature")) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format("Project ''{0}'' does not have the Java nature", this.name), null));
        }
    }

    protected void buildStructure(Body body, Map<IHandle, Body> newElements) throws CoreException {
        IClasspathEntry[] rawClasspath = this.getRawClasspath();
        ArrayList<PackageFragmentRoot> roots = new ArrayList<PackageFragmentRoot>();
        IPath projectPath = this.getPath();
        IClasspathEntry[] iClasspathEntryArray = rawClasspath;
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            PackageFragmentRoot root = null;
            IPath entryPath = entry.getPath();
            int entryKind = entry.getEntryKind();
            if (entryKind == 3 && projectPath.isPrefixOf(entryPath) && entryPath.segmentCount() == 2 && (resource = this.project.getParent().findMember(entryPath)) != null && resource.getType() == 2) {
                root = new PackageFragmentRoot(this, resource);
            }
            if (root != null) {
                roots.add(root);
            }
            ++n2;
        }
        body.setChildren(roots.toArray(new IHandle[roots.size()]));
    }

    protected Body newBody() {
        return new JavaProjectBody();
    }

    PerProjectInfo getPerProjectInfo() throws CoreException {
        return JavaModelManager.INSTANCE.getPerProjectInfoCheckExistence(this.project);
    }

    public IClasspathEntry[] getRawClasspath() throws CoreException {
        return this.getPerProjectInfo().getRawClasspath();
    }

    public IPath getOutputLocation() throws CoreException {
        return this.getPerProjectInfo().getOutputLocation();
    }

    void resetRawClasspath() {
        PerProjectInfo info = JavaModelManager.INSTANCE.getPerProjectInfo(this.project, false);
        if (info != null) {
            info.setRawClasspath(null, null);
        }
    }

    public String getOption(String optionName, boolean inheritJavaCoreOptions) {
        return JavaCore.create((IProject)this.project).getOption(optionName, inheritJavaCoreOptions);
    }

    public Map<String, String> getOptions(boolean inheritJavaCoreOptions) {
        return JavaCore.create((IProject)this.project).getOptions(inheritJavaCoreOptions);
    }
}

