/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.internal.examples.javamodel.ClasspathUtil;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.jdt.core.IClasspathEntry;

public class JavaProjectBody
extends Body {
    private volatile IResource[] nonJavaResources;

    public IResource[] getNonJavaResources(JavaProject javaProject) throws CoreException {
        IResource[] nonJavaResources = this.nonJavaResources;
        if (nonJavaResources == null) {
            this.nonJavaResources = nonJavaResources = this.computeNonJavaResources(javaProject);
        }
        return nonJavaResources;
    }

    void setNonJavaResources(IResource[] resources) {
        this.nonJavaResources = resources;
    }

    private IResource[] computeNonJavaResources(JavaProject javaProject) throws CoreException {
        IResource[] members;
        ArrayList<IResource> result = new ArrayList<IResource>();
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        IResource[] iResourceArray = members = javaProject.getProject().members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (!ClasspathUtil.isSourceFolder(member, rawClasspath)) {
                result.add(member);
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }
}

