/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.IHandleDelta;
import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.OutlineContribution;

public abstract class ElementChangeListenerContribution
extends OutlineContribution {
    private IElementChangeListener listener = new IElementChangeListener(){

        public void elementChanged(IElementChangeEvent event) {
            if (ElementChangeListenerContribution.this.affects(event, ElementChangeListenerContribution.this.getOutlinePage().getTreeViewer().getInput())) {
                ElementChangeListenerContribution.this.elementChanged(event);
            }
        }
    };

    @Override
    public void init(ICommonOutlinePage outlinePage) {
        super.init(outlinePage);
        this.addElementChangeListener(this.listener);
    }

    @Override
    public void dispose() {
        if (this.getOutlinePage() != null) {
            this.removeElementChangeListener(this.listener);
        }
        super.dispose();
    }

    protected boolean affects(IElementChangeEvent event, Object inputElement) {
        if (inputElement instanceof IHandle) {
            return this.affects(event.getDelta(), (IHandle)inputElement);
        }
        return false;
    }

    protected boolean affects(IHandleDelta delta, IHandle element) {
        IHandleDelta[] children;
        if (delta.getElement().equals((Object)element)) {
            return true;
        }
        IHandleDelta[] iHandleDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IHandleDelta child = iHandleDeltaArray[n2];
            if (this.affects(child, element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected abstract void addElementChangeListener(IElementChangeListener var1);

    protected abstract void removeElementChangeListener(IElementChangeListener var1);

    protected abstract void elementChanged(IElementChangeEvent var1);
}

