/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.quickoutline;

import org.eclipse.handly.internal.ui.SourceElementUtil;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.ui.IElementForEditorInputFactory;
import org.eclipse.handly.ui.quickoutline.FilteringOutlinePopup;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;

public abstract class HandlyOutlinePopup
extends FilteringOutlinePopup {
    private IElementForEditorInputFactory inputElementFactory;

    public void setInputElementFactory(IElementForEditorInputFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        this.inputElementFactory = factory;
    }

    @Override
    protected Object computeInput() {
        return this.getInputElementFactory().getElement(this.getHost().getEditorInput());
    }

    @Override
    protected Object getCorrespondingElement(ISelection hostSelection) {
        if (!(hostSelection instanceof ITextSelection)) {
            return null;
        }
        Object input = this.getTreeViewer().getInput();
        if (!(input instanceof ISourceElement)) {
            return null;
        }
        return SourceElementUtil.getElementAt((ISourceElement)input, ((ITextSelection)hostSelection).getOffset());
    }

    @Override
    protected boolean revealInHost(Object outlineElement) {
        if (!(outlineElement instanceof ISourceElement)) {
            return false;
        }
        ISourceElement sourceElement = (ISourceElement)outlineElement;
        if (!this.isInHost((IHandle)sourceElement)) {
            return false;
        }
        TextRange identifyingRange = SourceElementUtil.getIdentifyingRange(sourceElement);
        if (identifyingRange == null) {
            return false;
        }
        TextSelection textSelection = new TextSelection(identifyingRange.getOffset(), identifyingRange.getLength());
        this.getHost().getSelectionProvider().setSelection((ISelection)textSelection);
        return true;
    }

    protected boolean isInHost(IHandle element) {
        IHandle inputElement = this.getInputElementFactory().getElement(this.getHost().getEditorInput());
        while (element != null) {
            if (element.equals((Object)inputElement)) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    protected IElementForEditorInputFactory getInputElementFactory() {
        return this.inputElementFactory;
    }
}

