/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.texteditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.IDocumentBuffer;
import org.eclipse.handly.buffer.UiBufferChangeRunner;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorBuffer
implements IDocumentBuffer {
    private volatile boolean closed;
    protected final IEditorInput editorInput;
    protected final IDocumentProvider documentProvider;
    protected final IDocument document;

    public TextEditorBuffer(ITextEditor editor) throws CoreException {
        if (editor == null) {
            throw new IllegalArgumentException();
        }
        this.editorInput = editor.getEditorInput();
        if (this.editorInput == null) {
            throw new IllegalArgumentException();
        }
        this.documentProvider = editor.getDocumentProvider();
        if (this.documentProvider == null) {
            throw new IllegalArgumentException();
        }
        this.documentProvider.connect((Object)this.editorInput);
        this.document = this.documentProvider.getDocument((Object)this.editorInput);
    }

    public IDocument getDocument() {
        this.checkNotClosed();
        return this.document;
    }

    public ISnapshot getSnapshot() {
        this.checkNotClosed();
        return new DocumentSnapshot(this.document);
    }

    public IBufferChange applyChange(IBufferChange change, IProgressMonitor pm) throws CoreException {
        this.checkNotClosed();
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        try {
            UiBufferChangeRunner runner = new UiBufferChangeRunner(UiSynchronizer.DEFAULT, this.createChangeOperation(change));
            return runner.run(pm);
        }
        catch (MalformedTreeException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    public void setContents(String contents) {
        this.checkNotClosed();
        this.document.set(contents);
    }

    public boolean hasUnsavedChanges() {
        this.checkNotClosed();
        return this.documentProvider.canSaveDocument((Object)this.editorInput);
    }

    public boolean mustSaveChanges() {
        this.checkNotClosed();
        return this.documentProvider.mustSaveDocument((Object)this.editorInput);
    }

    public void save(boolean overwrite, IProgressMonitor pm) throws CoreException {
        this.checkNotClosed();
        this.documentProvider.saveDocument(pm, (Object)this.editorInput, this.document, overwrite);
    }

    public void dispose() {
        this.checkNotClosed();
        this.closed = true;
        this.documentProvider.disconnect((Object)this.editorInput);
    }

    public int hashCode() {
        return this.document.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextEditorBuffer other = (TextEditorBuffer)obj;
        return this.document == other.document;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void checkNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("the buffer has been closed");
        }
    }

    protected BufferChangeOperation createChangeOperation(IBufferChange change) {
        return new BufferChangeOperation((IDocumentBuffer)this, change);
    }
}

